package ru.yandex.infra.stage.yp;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class Retainment {
    private final boolean isRetained;
    private final String reason;

    public Retainment(boolean isRetained, String reason) {
        this.isRetained = isRetained;
        this.reason = reason;
    }

    public boolean isRetained() {
        return isRetained;
    }

    public String getReason() {
        return reason;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Retainment)) {
            return false;
        }
        Retainment that = (Retainment) o;
        return isRetained == that.isRetained &&
                Objects.equals(reason, that.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isRetained, reason);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("isRetained", isRetained)
                .add("reason", reason)
                .toString();
    }
}
