package ru.yandex.infra.stage.yp;

import java.util.Collections;
import java.util.Map;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class SpecStatusMeta<Meta, Spec, Status> {
    private final Spec spec;
    private final Status status;
    private final Meta meta;
    private final long specTimestamp;
    private final long metaTimestamp;
    private final Map<String, YTreeNode> labels;

    @VisibleForTesting
    public SpecStatusMeta(Spec spec, Status status, Meta meta, long specTimestamp, long metaTimestamp, Map<String, YTreeNode> labels) {
        this.spec = spec;
        this.status = status;
        this.meta = meta;
        this.specTimestamp = specTimestamp;
        this.metaTimestamp = metaTimestamp;
        this.labels = labels;
    }

    @VisibleForTesting
    public SpecStatusMeta(Spec spec, Status status, Meta meta, long specTimestamp, long metaTimestamp) {
        this(spec, status, meta, specTimestamp, metaTimestamp, Collections.emptyMap());
    }

    public static <Meta, Spec, Status> SpecStatusMeta<Meta, Spec, Status> fromYpObject(YpObject<Meta, Spec, Status> object) {
        return new SpecStatusMeta<>(object.getSpec(), object.getStatus(), object.getMeta(), object.getSpecTimestamp(),
                object.getMetaTimestamp(), object.getLabels());
    }

    public Spec getSpec() {
        return spec;
    }

    public Status getStatus() {
        return status;
    }

    public Meta getMeta() {
        return meta;
    }

    public long getSpecTimestamp() {
        return specTimestamp;
    }

    public long getMetaTimestamp() {
        return metaTimestamp;
    }

    public Map<String, YTreeNode> getLabels() {
        return labels;
    }
}
