package ru.yandex.infra.stage.yp;

import java.util.Objects;

import ru.yandex.infra.controller.dto.Acl;

public class SpecWithAcl<Spec> {
    private final Spec spec;
    private final Acl acl;

    public SpecWithAcl(Spec spec, Acl acl) {
        this.spec = spec;
        this.acl = acl;
    }

    public Spec getSpec() {
        return spec;
    }

    public Acl getAcl() {
        return acl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SpecWithAcl)) return false;
        SpecWithAcl<?> that = (SpecWithAcl<?>) o;
        return Objects.equals(spec, that.spec) &&
                Objects.equals(acl, that.acl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(spec, acl);
    }
}
