package ru.yandex.infra.stage.yp;

import java.util.Map;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class Yson {
    public static YTreeMapNode asYtree(Map<String, String> map) {
        YTreeBuilder builder = new YTreeBuilder().beginMap();
        map.forEach((key, value) -> builder.key(key).value(value));
        return builder.buildMap();
    }

    public static String protoAsJson(Message message) {
        try {
            return JsonFormat.printer()
                    .preservingProtoFieldNames()
                    .includingDefaultValueFields()
                    .print(message);
        } catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }
}
