JAVA_PROGRAM(stage_controller)

JDK_VERSION(11)

OWNER(
    amich
    dkochetov
    crastin
    g:deploy
    g:deploy-orchestration
)

INCLUDE(${ARCADIA_ROOT}/library/java/dependency_management.inc)

SET(COMMONS_IO_VERSION 1.3.2)
SET(JACKSON_VERSION 2.9.8)
SET(JACKSON_YAML_VERSION 2.9.8)
SET(JSR305_VERSION 3.0.0)
SET(TYPESAFE_CONFIG_VERSION 1.4.0)
SET(MOCKITO_VERSION 2.25.1)
SET(STREAMEX_VERSION 0.6.7)
SET(JETTY_VERSION 9.4.18.v20190429)
SET(QE_VERSION 6.3252)
SET(DISRUPTOR_VERSION 3.4.2)
SET(SLF4J_LOG4J_VERSION 2.16.0)
SET(LOGSTASH_LOGBACK_ENCODER 4.11)
SET(LOGBACK 1.2.3)
SET(JAEGER 1.4.0)
PEERDIR(
    iceberg/inside-yt
    yt/java/ytclient

    infra/libs/java/controller/controller
    infra/stage_controller/proto

    yp/java/yp
    yp/yp_proto/yp/client/api/proto

    contrib/java/org/apache/commons/commons-io/${COMMONS_IO_VERSION}

    contrib/java/com/google/guava/guava/${GUAVA_VERSION}
    contrib/java/com/google/protobuf/protobuf-java-util

    contrib/java/com/google/code/findbugs/jsr305/${JSR305_VERSION}

    # Needed by log4j2 for async logging
    # See https://logging.apache.org/log4j/2.x/manual/async.html
    contrib/java/com/lmax/disruptor/${DISRUPTOR_VERSION}

    contrib/java/com/fasterxml/jackson/core/jackson-databind/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/core/jackson-core/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml/${JACKSON_YAML_VERSION}

    contrib/java/com/typesafe/config/${TYPESAFE_CONFIG_VERSION}

    contrib/java/org/eclipse/jetty/jetty-server/${JETTY_VERSION}
    contrib/java/org/eclipse/jetty/jetty-servlet/${JETTY_VERSION}
    contrib/java/org/mockito/mockito-core/${MOCKITO_VERSION}
    contrib/java/one/util/streamex/${STREAMEX_VERSION}
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl/${SLF4J_LOG4J_VERSION}
    contrib/java/net/logstash/logback/logstash-logback-encoder/${LOGSTASH_LOGBACK_ENCODER}
    contrib/java/ch/qos/logback/logback-classic/${LOGBACK}
    contrib/java/ch/qos/logback/logback-core/${LOGBACK}
    contrib/java/io/jaegertracing/jaeger-client/${JAEGER}
)

EXCLUDE(
    # some clashes inside iceberg-xml
    contrib/java/xml-apis/xml-apis
    contrib/java/log4j/log4j/1.2.17

    # fix for clash with qe telemetry
    contrib/java/ch/qos/logback/logback-classic
    contrib/java/net/logstash/logback/logstash-logback-encoder
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl
    contrib/java/com/sun/activation/javax.activation/1.2.0
    contrib/java/commons-io/commons-io/2.0.1
    contrib/java/commons-io/commons-io/2.4
    contrib/java/commons-logging/commons-logging
    contrib/java/ch/qos/logback/logback-core
    contrib/java/org/apache/commons/commons-io/1.3.2
    contrib/java/org/slf4j/log4j-over-slf4j
    contrib/java/org/slf4j/slf4j-simple
)

JAVA_SRCS(SRCDIR src/main/java **/*.java)
JAVA_SRCS(SRCDIR src/main/resources **/*)

UBERJAR()

UBERJAR_PATH_EXCLUDE_PREFIX(
    # fix for DEVTOOLS-5190, see also https://stackoverflow.com/a/6743609
    META-INF/DUMMY.DSA
    META-INF/DUMMY.SF
    META-INF/SAXONICA.RSA
    META-INF/SAXONICA.SF
    # fix for https://stackoverflow.com/q/34945438
    META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat
)

LINT(strict)

WITH_JDK()

NEED_CHECK()

END()

RECURSE(
    it
    scripts
    ut
)
