# coding: utf-8
"""
Authentication error handlers.
"""
from flask import g

from sepelib.flask.h.error_handlers import exception_handler


@exception_handler
def handle_permission_denied(_):
    login = g.identity.id if hasattr(g, 'identity') and g.identity.id else "<unknown>"
    message = u"User '{0}' is not authorized.".format(login)
    return message, 403
