import hashlib
from base64 import urlsafe_b64encode

import six


def login_exempt(view):
    """
    A decorator that can exclude a view from authentication and authorization processes.

    :param view: flask request handling function
    """
    view.need_auth = False
    return view


def sign_in_memory(data, key):
    return urlsafe_b64encode(bytes(key.sign_ssh_data(six.b(data))))


def default_hash(value):
    return hashlib.sha256(value).hexdigest()


def serialize_request(method, path, data, timestamp, login):
    r = '%s\n%s\n%s\n%s\n%s\n' % (method.upper(), path, data, timestamp, login)
    return r.encode('utf-8')


def rsa_sign_data(data, key):
    return sign_in_memory(default_hash(data), key=key)
