class CLimit(object):
    """
    In contrast with rate limit this is a capacity limiter, which allows maximum number of concurrent
    requests being in flight.
    It is single threaded version, i.e. it assumes that no switches are possible during add/done methods.
    """
    __slots__ = ['_cur', '_lim']

    def __init__(self, limit):
        self._cur = 0
        self._lim = limit

    def add(self):
        if self._cur >= self._lim:
            return False
        self._cur += 1
        return True

    def done(self):
        self._cur -= 1

    def __str__(self):
        return "CLimit(cur={},limit={})".format(self._cur, self._lim)
