"""
Collection of utilities for gevent.
"""
from __future__ import absolute_import

import itertools
import six
import gevent


def idle_iter(iterable_object, idle_period=100, idle_on_start=False, idle_method=None):
    """
    Make gevent.idle pauses during iteration - call idle_method.
    Do not let gevent block your program!

    :param iterable_object: iterable object
    :type iterable_object: collections.Iterable[T]
    :param idle_period: idle frequency
    :param idle_on_start: make idle before first iteration
    :type idle_on_start: bool
    :param idle_method: idle method object
    :rtype: list[T]
    """
    if idle_method is None:
        idle_method = gevent.idle
    for iterable_item_id, iterable_item in enumerate(iterable_object, 0 if idle_on_start else 1):
        if not iterable_item_id % idle_period:
            idle_method()
        yield iterable_item


def get_periodic_gevent_idle(idle_period=100, idle_on_start=False, idle_method=None):
    g = idle_iter(itertools.repeat(None),
                  idle_period=idle_period,
                  idle_on_start=idle_on_start,
                  idle_method=idle_method)
    if six.PY3:
        return g.__next__
    else:
        return g.next
