from __future__ import unicode_literals

import logging
import os
import string
import random


ALNUM = string.ascii_uppercase + string.digits
OP_LOG_FORMAT = "%(hostname)s %(process)s %(asctime)s %(levelname)s [%(name)s] [%(op_id)s] %(message)s"


class OpIdFilter(logging.Filter):
    def filter(self, record):
        record.op_id = getattr(record, 'op_id', '-')
        return True


def rndstr(n=5):
    return ''.join(random.sample(ALNUM, n))


def add_logfile_prefix(file_path, prefix):
    """
    Transforms path to file by adding prefix and '_' to filename.

    E.g.
    /usr/local/www/logs/nanny/production_nanny_8083.log
    is transformed into
    /usr/local/www/logs/nanny/prefix_production_nanny_8083.log

    Intended for use in sidecar processes which use same configuration file as main nanny process.
    """
    d = os.path.dirname(file_path)
    f = os.path.basename(file_path)
    return os.path.join(d, '{}_{}'.format(prefix, f))


def get_op_log(log, op_id):
    """
    :type log: logging.Logger
    :type op_id: Optional[str | unicode]
    """
    op_id = op_id or rndstr()
    return logging.LoggerAdapter(log, {b'op_id': op_id})
