from __future__ import unicode_literals

import functools

import flask

from infra.swatlib import climit


LIMIT_REACHED_RESPONSE = flask.Response(
    response=b'{"error": "TOO_MANY_REQUESTS", "message": "Concurrent requests limit reached"}',
    status=429,
    headers={'Content-Type': 'application/json'},
)


class ViewRequestLimiter(object):

    def __init__(self, limit):
        self.limiter = climit.CLimit(limit)

    def __call__(self, view):

        @functools.wraps(view)
        def wrapper(*args, **kwargs):
            if not self.limiter.add():
                return LIMIT_REACHED_RESPONSE
            try:
                return view(*args, **kwargs)
            finally:
                self.limiter.done()

        return wrapper


def limit(l):
    return ViewRequestLimiter(l)
