from infra.swatlib.httpclient import HttpClient, HttpClientException


class ISandboxClient(object):
    """
    Interface to be used in dependency injection.
    """


class SandboxError(HttpClientException):
    pass


class SandboxClient(object):
    SANDBOX_API_URL = 'https://sandbox.yandex-team.ru/api/v1.0/'
    DEFAULT_REQ_TIMEOUT = 10  # seconds
    DEFAULT_RESPONSE_LIMIT = 200
    DEFAULT_VERIFY_SSL = True

    @classmethod
    def from_config(cls, d):
        return cls(sandbox_url=d.get('api_url'),
                   oauth_token=d.get('oauth_token'),
                   req_timeout=d.get('req_timeout'),
                   verify_ssl=d.get('verify_ssl'),
                   limit=d.get('response_entities_limit'),
                   max_retries=d.get('max_retries'))

    def __init__(self, sandbox_url=None, oauth_token=None, req_timeout=None, verify_ssl=None,
                 limit=None, max_retries=None):
        sandbox_url = sandbox_url or self.SANDBOX_API_URL
        token = oauth_token
        req_timeout = req_timeout or self.DEFAULT_REQ_TIMEOUT
        verify_ssl = self.DEFAULT_VERIFY_SSL if verify_ssl is None else verify_ssl
        self._client = HttpClient(client_name='sandbox',
                                  exc_cls=SandboxError,
                                  base_url=sandbox_url,
                                  req_timeout=req_timeout,
                                  token=token,
                                  verify=verify_ssl,
                                  max_retries=max_retries)
        self._limit = self.DEFAULT_RESPONSE_LIMIT if limit is None else limit

    def get_task(self, task_id):
        rel_url = 'task/{}'.format(task_id)
        return self._client.get(rel_url)

    def get_resource(self, resource_id):
        rel_url = 'resource/{}'.format(resource_id)
        return self._client.get(rel_url)
