from six.moves import http_client as httplib

import flask
from infra.swatlib.auth.util import login_exempt

from infra.swatlib.stacksampler.stacksampler import SAMPLER

sampler_bp = flask.Blueprint('stacksampler', __name__, url_prefix='/_stacksampler')


@sampler_bp.route('/start/')
@login_exempt
def start_sampler():
    SAMPLER.start()
    return flask.Response('', status=httplib.OK)


@sampler_bp.route('/stop/')
@login_exempt
def stop_sampler():
    SAMPLER.stop()
    return flask.Response('', status=httplib.OK)


@sampler_bp.route('/reset/')
@login_exempt
def reset_sampler():
    SAMPLER.reset()
    return flask.Response('', status=httplib.OK)


@sampler_bp.route('/stats/')
@login_exempt
def get_stats():
    s = SAMPLER.output_stats()
    return flask.Response(s, status=httplib.OK)
