from infra.swatlib.storage import consts


class IWatchableCachingStorage(object):
    """
    Storage interface which allows storing/watching changes.
    """

    def watch_list(self):
        """
        Starts watching a list of objects and yields tuple (added, removed) keys.
        """
        raise NotImplementedError

    def get(self, key, consistency=consts.CONSISTENCY_STRONG, default=None):
        """
        Returns content of specified key.

        :type key: unicode
        :type consistency: unicode
        :type default: optional[Any]
        """
        raise NotImplementedError

    def list_keys(self, consistency=consts.CONSISTENCY_STRONG):
        """
        Returns keys of all stored objects.

        :rtype: list[unicode]
        """
        raise NotImplementedError

    def list(self, consistency=consts.CONSISTENCY_STRONG):
        """
        Returns all stored objects.
        """
        raise NotImplementedError

    def watch(self, key):
        """
        Starts a watch and yields object as soon as specified key changes.

        :type key: basestring
        """
        raise NotImplementedError

    def create(self, key, obj):
        """
        Creates new key in storage if not exists, otherwise raises error.
        """
        raise NotImplementedError

    def update_conditionally(self, key, value, version):
        """
        :type key: unicode
        :type value: Any
        :type version: optional[unicode]
        """
        raise NotImplementedError

    def guaranteed_update(self, key, update_func):
        """
        1. Fetches specified key from storage.
        2. Calls update_func to perform object update.
        3. Stores object conditionally
        4. If condition fails - cycle repeats

        :param key: object key
        :param update_func: function, which updates object
        :type key: unicode
        :type update_func: collections.Callable
        """
        raise NotImplementedError

    def remove(self, key):
        raise NotImplementedError

    def start(self):
        raise NotImplementedError

    def stop(self):
        raise NotImplementedError

    def listen(self, listener):
        """
        Add an event listener

        :type listener: collections.Callable
        """
        raise NotImplementedError
