from __future__ import unicode_literals

import logging

import gevent

from sepelib.util import retry
from infra.swatlib.storage import errors


log = logging.getLogger(__name__)


def run_watch(key, queue, s):
    """
    :type key: unicode
    :type queue: gevent.queue.Queue
    :type s: infra.swatlib.storage.interfaces.IWatchableCachingStorage
    """
    try:
        while 1:
            try:
                w = s.watch(key)
                while 1:
                    queue.put(next(w))
            except errors.NodeNotFoundError:
                gevent.sleep(30)
                continue
    except Exception as e:
        log.error('Watch on "{}" failed: {}'.format(key, e))
        queue.put(e)


def run_periodic(key, queue, s):
    """
    :type key: unicode
    :type queue: gevent.queue.Queue
    :type s: infra.swatlib.storage.interfaces.IWatchableCachingStorage
    """
    # Sleep for some random time to avoid herding
    r = retry.RetrySleeper(delay=5 * 60,
                           max_jitter=10 * 60, max_delay=60 * 60,
                           sleep_func=gevent.sleep)
    try:
        while 1:
            r.increment()
            try:
                w = s.get(key)
            except errors.NodeNotFoundError:
                gevent.sleep(30)
                continue
            else:
                queue.put(w)
    except Exception as e:
        log.error('Get on "{}" failed: {}'.format(key, e))
        queue.put(e)
