from infra.swatlib.storage.zk import treecache


class RootStructure(treecache.Structure):
    def __init__(self, nested):
        """
        :type nested: treecache.Structure
        """
        self._nested = nested

    def get_codec(self):
        return None

    def get_child(self, path):
        return self._nested

    def is_leaf(self):
        return False


class DataNode(treecache.Structure):
    def __init__(self, codec):
        """
        :type codec: swatlib.zk.treecache.Codec
        """
        self._codec = codec

    def get_codec(self):
        return self._codec

    def get_child(self, path):
        return None

    def is_leaf(self):
        return True


def make_structure(codec):
    """
    :type codec: swatlib.zk.treecache.Codec
    :rtype: RootStructure
    """
    return RootStructure(nested=DataNode(codec))
