import gevent
from thrift.transport import TSocket


class TConnectionTimeoutAwareSocket(TSocket.TSocketBase):

    def __init__(self, socket, connection_timeout_ms):
        """
        :type socket: thrift.transport.TSocket.TSocket
        :type connection_timeout_ms: int
        """
        self._sock = socket
        self._conn_timeout = connection_timeout_ms / 1000.0

    def isOpen(self):
        return self._sock.isOpen()

    def setHandle(self, h):
        return self._sock.setHandle(h)

    def setTimeout(self, ms):
        return self._sock.setTimeout(ms)

    def open(self):
        with gevent.Timeout(self._conn_timeout):
            return self._sock.open()

    def read(self, sz):
        return self._sock.read(sz)

    def write(self, buff):
        return self._sock.write(buff)

    def flush(self):
        return self._sock.flush()

    def close(self):
        return self._sock.close()

    def readAll(self, sz):
        return self._sock.readAll(sz)
