#!/usr/bin/env bash -ex

if [[ "$OSTYPE" == "linux-gnu" ]]; then
    platform="linux"
elif [[ "$OSTYPE" == "darwin"* ]]; then
    platform="macosx"
else
    echo "platform is not detected or not supported"
    exit 1;
fi

ARC_ROOT=$(realpath ../../../..)
PROTOBUF_DIR=${ARC_ROOT}/yp/python/ya_proto/yp_proto/yp/yp_proto/yp/client/api/proto
OUTPUT_DIR=$(realpath .)
MYPY_PLUGIN=./protoc-gen-mypy-"$platform"

protoc \
    -I ${ARC_ROOT}/yp/python/ya_proto \
    -I ${ARC_ROOT}/yt/19_3 \
    -I ${ARC_ROOT}/yt/19_3/yt/ya_proto \
    --plugin=protoc-gen-mypy=${MYPY_PLUGIN} \
    --mypy_out=${OUTPUT_DIR} \
    ${PROTOBUF_DIR}/*

sed -i '' -e 's/NYP.NClient.NApi.NProto.//g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/data_model_pb2.pyi
sed -i '' -e 's/NYP.NClient.NApi.NClusterApiProto.//g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/cluster_api_pb2.pyi
sed -i '' -e 's/NInfra.NPodAgent.API.//g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/pod_agent_pb2.pyi
sed -i '' -e 's/NInfra.NPodAgent.API/pod_agent_pb2/g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/data_model_pb2.pyi
sed -i '' -e 's/NYP.NClient.NApi.NProto.TPodSpec/data_model_pb2.TPodSpec/g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/replica_set_pb2.pyi
sed -i '' -e 's/NYP.NClient.NApi.NProto.//g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/replica_set_pb2.pyi
sed -i '' -e 's/# @generated by protoc-gen-mypy.  Do not edit!/# @generated by protoc-gen-mypy.  Do not edit!\
from . import pod_agent_pb2/g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/data_model_pb2.pyi
sed -i '' -e 's/# @generated by protoc-gen-mypy.  Do not edit!/# @generated by protoc-gen-mypy.  Do not edit!\
from . import data_model_pb2/g' ${OUTPUT_DIR}/yp_proto/yp/client/api/proto/replica_set_pb2.pyi
