package main

import (
	"fmt"
	"log"
	"net"
	"os"

	"a.yandex-team.ru/infra/tcp-sampler/pkg/samples"
	pb "a.yandex-team.ru/mds/valve/proto"
)

func main() {
	args := os.Args[1:]
	if len(args) == 0 {
		log.Fatalf("Determine dump path with -read option")
	} else {
		p := pb.NetSample{}
		err := samples.ReadProtoMessageFromFile(args[0], &p)
		if err != nil {
			log.Fatalf("Read error: %s", err)
		}

		for k, v := range p.Ns {
			fmt.Println("##############")
			fmt.Printf("Name: %s\n", k)
			for _, i := range v.Iface {
				fmt.Println("==============")
				fmt.Printf("  Iface: %s\n", i.Name)
				fmt.Println("  IPs:")
				for _, ip := range i.Ips {
					fmt.Printf("    %s\n", net.IP(ip).String())
				}
			}
			for _, t := range v.Tcp {
				fmt.Printf("  ----------------------------------\n")
				fmt.Printf("  SrcAddr (local): %s\n", net.IP(t.SrcAddr).String())
				fmt.Printf("  DstAddr (remote): %s\n", net.IP(t.DstAddr).String())
				fmt.Printf("  SrcPort (local): %d\n", t.SrcPort)
				fmt.Printf("  DstPort (remote): %d\n", t.DstPort)
				fmt.Printf("  Iface: %s\n", t.Iface)
				fmt.Printf("  Chain: %v\n", t.Chain)
				fmt.Printf("  SegsOut: %d\n", t.Tcpi.SegsOut)
				fmt.Printf("  SegsIn: %d\n", t.Tcpi.SegsIn)
				fmt.Printf("  TCPState: %v\n", t.Tcpi.State)
			}
		}

	}

}
