package hbfutil

import (
	"io/ioutil"
	"net/http"
	"os"
	"path/filepath"
	"regexp"
	"strings"

	"go.uber.org/zap"
)

const HBFURL = "http://localhost:9876/last-url"

func GrepURL(path string) (string, error) {
	bufSize := 65536
	r, _ := regexp.Compile(`(?m)URL:\s+<(?P<url>.*)>`)
	buf := make([]byte, bufSize)

	f, err := os.Open(path)
	if err != nil {
		return "", err
	}
	defer f.Close()

	stat, err := os.Stat(path)
	if err != nil {
		return "", err
	}
	start := stat.Size() - int64(bufSize)
	_, err = f.ReadAt(buf, start)
	if err != nil {
		return "", err
	}
	url := r.FindAllSubmatch(buf, -1)
	return string(url[0][1]), nil

}

func GetLastHBFURL(url *string) (string, error) {
	resp, err := http.Get(*url)
	if err != nil {
		return "", err
	}
	b, err := ioutil.ReadAll(resp.Body)
	_ = resp.Body.Close()
	if err != nil {
		return "", err
	}
	return strings.Trim(string(b), "\""), nil
}

func GetLocalRules(paths []string) (map[string][]byte, error) {
	r := make(map[string][]byte)

	for _, path := range paths {
		_ = filepath.Walk(path, func(path string, info os.FileInfo, err error) error {
			if filepath.Ext(path) == ".v6" {
				content, err := ioutil.ReadFile(path)
				if err != nil {
					zap.S().Debugf("Could not read %s", info.Name())
					content = []byte("Could not read")
				}
				r[info.Name()] = content
			}
			return nil
		})
	}
	return r, nil
}
