package lock

import (
	"golang.org/x/sys/unix"

	"go.uber.org/zap"
)

type lock struct {
	isLocked bool
	fd       int
	path     string
}

func Lock(path string) (*lock, error) {
	fd, err := unix.Open(path, unix.O_RDWR|unix.O_CREAT, 0755)
	if err != nil {
		return nil, err
	}
	err = unix.Flock(fd, unix.LOCK_EX|unix.LOCK_NB)
	if err != nil {
		_ = unix.Close(fd) // Can return err
		return nil, err
	}

	zap.S().Infof("Lock %s acquired", path)
	l := &lock{
		fd:       fd,
		isLocked: true,
		path:     path,
	}
	return l, nil
}

func (l lock) Unlock() error {
	if l.isLocked {
		err := unix.Flock(l.fd, unix.LOCK_UN)
		if err != nil {
			return err
		}
		err = unix.Close(l.fd)
		if err != nil {
			return err
		}
		err = unix.Unlink(l.path)
		if err != nil {
			return err
		}
		zap.S().Infof("Lock %s released", l.path)
	}
	return nil
}
