package portoutil

import (
	"strconv"

	"go.uber.org/zap"

	"a.yandex-team.ru/infra/tcp-sampler/pkg/porto"
)

func GetNotInherited() (map[string]int, error) {
	notInherited := make(map[string]int)

	c, err := porto.Connect()
	if err != nil {
		return notInherited, err
	}
	defer c.Close()

	allContainers, err := c.Get([]string{"***"}, []string{"net"})
	if err != nil {
		return notInherited, err
	}

	for k, v := range allContainers {
		if v["net"].Value != "inherited" {
			pidStr, err := c.GetProperty(k, "root_pid")
			if err != nil {
				zap.S().Debugf("Could not get pid for %s", k)
				continue
			}
			pid, err := strconv.Atoi(pidStr)
			if err != nil {
				zap.S().Debugf("unable to parse pid %s", pidStr)
			}
			notInherited[k] = pid
		}
	}

	notInherited["dom0"] = 1 // Add host's netNS
	return notInherited, nil
}
