// Code generated by protoc-gen-go. DO NOT EDIT.
// source: rpc.proto

/*
Package rpc is a generated protocol buffer package.

It is generated from these files:
	rpc.proto

It has these top-level messages:
	TContainerCreateRequest
	TContainerDestroyRequest
	TContainerListRequest
	TContainerGetPropertyRequest
	TContainerSetPropertyRequest
	TContainerGetDataRequest
	TContainerStartRequest
	TContainerStopRequest
	TContainerPauseRequest
	TContainerResumeRequest
	TContainerPropertyListRequest
	TContainerDataListRequest
	TContainerKillRequest
	TVersionRequest
	TConvertPathRequest
	TContainerGetRequest
	TContainerWaitRequest
	TAttachProcessRequest
	TPortoRequest
	TContainerListResponse
	TContainerGetPropertyResponse
	TContainerGetDataResponse
	TContainerPropertyListResponse
	TContainerDataListResponse
	TVersionResponse
	TContainerGetResponse
	TContainerWaitResponse
	TConvertPathResponse
	TPortoResponse
	TVolumeProperty
	TVolumePropertyDescription
	TVolumeDescription
	TVolumePropertyListRequest
	TVolumePropertyListResponse
	TVolumeCreateRequest
	TVolumeLinkRequest
	TVolumeUnlinkRequest
	TVolumeListRequest
	TVolumeTuneRequest
	TVolumeListResponse
	TLayerImportRequest
	TLayerExportRequest
	TLayerRemoveRequest
	TLayerListRequest
	TLayerGetPrivateRequest
	TLayerSetPrivateRequest
	TLayerDescription
	TLayerListResponse
	TLayerGetPrivateResponse
	TStorageDescription
	TStorageListRequest
	TStorageListResponse
	TStorageRemoveRequest
	TStorageImportRequest
	TStorageExportRequest
*/
package rpc

import proto "github.com/golang/protobuf/proto"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

// List of error codes
type EError int32

const (
	// Request executed successfully. No errors occured.
	EError_Success EError = 0
	// Unknown critical error.
	EError_Unknown EError = 1
	// Unknown or bad request
	EError_InvalidMethod EError = 2
	// Container with specified name already exists. Can't create a new one.
	EError_ContainerAlreadyExists EError = 3
	// Container with specified name doesn't exist.
	EError_ContainerDoesNotExist EError = 4
	// Unknown property specified.
	EError_InvalidProperty EError = 5
	// Unknown data specified.
	EError_InvalidData EError = 6
	// Invalid value of property or data.
	EError_InvalidValue EError = 7
	// Can't perform specified operation in current container state.
	EError_InvalidState EError = 8
	// Operation is not supported due to some reasons (old kernel version, missing
	// kernel modules, etc).
	EError_NotSupported EError = 9
	// Requested resources are not available (e.g. can't allocate requested memory
	// without overcommiting).
	EError_ResourceNotAvailable EError = 10
	// Insufficient rights for performing requested operation.
	EError_Permission EError = 11
	// Can't create new volume with specified name, because there is already one.
	EError_VolumeAlreadyExists EError = 12
	// Volume with specified name doesn't exist.
	EError_VolumeNotFound EError = 13
	// Operation failed because of insufficient disk space.
	EError_NoSpace EError = 14
	// Operation can't be performed, because container or volume are in use by
	// other simultaneous operation.
	EError_Busy EError = 15
	// Volume already linked with container
	EError_VolumeAlreadyLinked EError = 16
	// Volume not linked with container
	EError_VolumeNotLinked    EError = 17
	EError_LayerAlreadyExists EError = 18
	EError_LayerNotFound      EError = 19
	// Reserved error code used by Porto internals. Can't be returned to a user.
	EError_Queued EError = 1000
)

var EError_name = map[int32]string{
	0:    "Success",
	1:    "Unknown",
	2:    "InvalidMethod",
	3:    "ContainerAlreadyExists",
	4:    "ContainerDoesNotExist",
	5:    "InvalidProperty",
	6:    "InvalidData",
	7:    "InvalidValue",
	8:    "InvalidState",
	9:    "NotSupported",
	10:   "ResourceNotAvailable",
	11:   "Permission",
	12:   "VolumeAlreadyExists",
	13:   "VolumeNotFound",
	14:   "NoSpace",
	15:   "Busy",
	16:   "VolumeAlreadyLinked",
	17:   "VolumeNotLinked",
	18:   "LayerAlreadyExists",
	19:   "LayerNotFound",
	1000: "Queued",
}
var EError_value = map[string]int32{
	"Success":                0,
	"Unknown":                1,
	"InvalidMethod":          2,
	"ContainerAlreadyExists": 3,
	"ContainerDoesNotExist":  4,
	"InvalidProperty":        5,
	"InvalidData":            6,
	"InvalidValue":           7,
	"InvalidState":           8,
	"NotSupported":           9,
	"ResourceNotAvailable":   10,
	"Permission":             11,
	"VolumeAlreadyExists":    12,
	"VolumeNotFound":         13,
	"NoSpace":                14,
	"Busy":                   15,
	"VolumeAlreadyLinked":    16,
	"VolumeNotLinked":        17,
	"LayerAlreadyExists":     18,
	"LayerNotFound":          19,
	"Queued":                 1000,
}

func (x EError) Enum() *EError {
	p := new(EError)
	*p = x
	return p
}
func (x EError) String() string {
	return proto.EnumName(EError_name, int32(x))
}
func (x *EError) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EError_value, data, "EError")
	if err != nil {
		return err
	}
	*x = EError(value)
	return nil
}

type TContainerCreateRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerCreateRequest) Reset()         { *m = TContainerCreateRequest{} }
func (m *TContainerCreateRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerCreateRequest) ProtoMessage()    {}

func (m *TContainerCreateRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type TContainerDestroyRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerDestroyRequest) Reset()         { *m = TContainerDestroyRequest{} }
func (m *TContainerDestroyRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerDestroyRequest) ProtoMessage()    {}

func (m *TContainerDestroyRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type TContainerListRequest struct {
	Mask             *string `protobuf:"bytes,1,opt,name=mask" json:"mask,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerListRequest) Reset()         { *m = TContainerListRequest{} }
func (m *TContainerListRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerListRequest) ProtoMessage()    {}

func (m *TContainerListRequest) GetMask() string {
	if m != nil && m.Mask != nil {
		return *m.Mask
	}
	return ""
}

type TContainerGetPropertyRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Property         *string `protobuf:"bytes,2,req,name=property" json:"property,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerGetPropertyRequest) Reset()         { *m = TContainerGetPropertyRequest{} }
func (m *TContainerGetPropertyRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerGetPropertyRequest) ProtoMessage()    {}

func (m *TContainerGetPropertyRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerGetPropertyRequest) GetProperty() string {
	if m != nil && m.Property != nil {
		return *m.Property
	}
	return ""
}

type TContainerSetPropertyRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Property         *string `protobuf:"bytes,2,req,name=property" json:"property,omitempty"`
	Value            *string `protobuf:"bytes,3,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerSetPropertyRequest) Reset()         { *m = TContainerSetPropertyRequest{} }
func (m *TContainerSetPropertyRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerSetPropertyRequest) ProtoMessage()    {}

func (m *TContainerSetPropertyRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerSetPropertyRequest) GetProperty() string {
	if m != nil && m.Property != nil {
		return *m.Property
	}
	return ""
}

func (m *TContainerSetPropertyRequest) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type TContainerGetDataRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Data             *string `protobuf:"bytes,2,req,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerGetDataRequest) Reset()         { *m = TContainerGetDataRequest{} }
func (m *TContainerGetDataRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerGetDataRequest) ProtoMessage()    {}

func (m *TContainerGetDataRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerGetDataRequest) GetData() string {
	if m != nil && m.Data != nil {
		return *m.Data
	}
	return ""
}

type TContainerStartRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerStartRequest) Reset()         { *m = TContainerStartRequest{} }
func (m *TContainerStartRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerStartRequest) ProtoMessage()    {}

func (m *TContainerStartRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type TContainerStopRequest struct {
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// Timeout between SIGTERM and SIGKILL, default 30s
	TimeoutMs        *uint32 `protobuf:"varint,2,opt,name=timeout_ms" json:"timeout_ms,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerStopRequest) Reset()         { *m = TContainerStopRequest{} }
func (m *TContainerStopRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerStopRequest) ProtoMessage()    {}

func (m *TContainerStopRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerStopRequest) GetTimeoutMs() uint32 {
	if m != nil && m.TimeoutMs != nil {
		return *m.TimeoutMs
	}
	return 0
}

type TContainerPauseRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerPauseRequest) Reset()         { *m = TContainerPauseRequest{} }
func (m *TContainerPauseRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerPauseRequest) ProtoMessage()    {}

func (m *TContainerPauseRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type TContainerResumeRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerResumeRequest) Reset()         { *m = TContainerResumeRequest{} }
func (m *TContainerResumeRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerResumeRequest) ProtoMessage()    {}

func (m *TContainerResumeRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type TContainerPropertyListRequest struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TContainerPropertyListRequest) Reset()         { *m = TContainerPropertyListRequest{} }
func (m *TContainerPropertyListRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerPropertyListRequest) ProtoMessage()    {}

type TContainerDataListRequest struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TContainerDataListRequest) Reset()         { *m = TContainerDataListRequest{} }
func (m *TContainerDataListRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerDataListRequest) ProtoMessage()    {}

type TContainerKillRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Sig              *int32  `protobuf:"varint,2,req,name=sig" json:"sig,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerKillRequest) Reset()         { *m = TContainerKillRequest{} }
func (m *TContainerKillRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerKillRequest) ProtoMessage()    {}

func (m *TContainerKillRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerKillRequest) GetSig() int32 {
	if m != nil && m.Sig != nil {
		return *m.Sig
	}
	return 0
}

// Get Porto version
type TVersionRequest struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TVersionRequest) Reset()         { *m = TVersionRequest{} }
func (m *TVersionRequest) String() string { return proto.CompactTextString(m) }
func (*TVersionRequest) ProtoMessage()    {}

type TConvertPathRequest struct {
	Path             *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Source           *string `protobuf:"bytes,2,req,name=source" json:"source,omitempty"`
	Destination      *string `protobuf:"bytes,3,req,name=destination" json:"destination,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TConvertPathRequest) Reset()         { *m = TConvertPathRequest{} }
func (m *TConvertPathRequest) String() string { return proto.CompactTextString(m) }
func (*TConvertPathRequest) ProtoMessage()    {}

func (m *TConvertPathRequest) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *TConvertPathRequest) GetSource() string {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return ""
}

func (m *TConvertPathRequest) GetDestination() string {
	if m != nil && m.Destination != nil {
		return *m.Destination
	}
	return ""
}

// Get multiple properties/data of many containers with one request
// (useful for monitoring)
type TContainerGetRequest struct {
	// list of containers
	Name []string `protobuf:"bytes,1,rep,name=name" json:"name,omitempty"`
	// list of properties/data
	Variable []string `protobuf:"bytes,2,rep,name=variable" json:"variable,omitempty"`
	// do not wait busy containers
	Nonblock         *bool  `protobuf:"varint,3,opt,name=nonblock" json:"nonblock,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TContainerGetRequest) Reset()         { *m = TContainerGetRequest{} }
func (m *TContainerGetRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerGetRequest) ProtoMessage()    {}

func (m *TContainerGetRequest) GetName() []string {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *TContainerGetRequest) GetVariable() []string {
	if m != nil {
		return m.Variable
	}
	return nil
}

func (m *TContainerGetRequest) GetNonblock() bool {
	if m != nil && m.Nonblock != nil {
		return *m.Nonblock
	}
	return false
}

// Wait while container(s) is/are in running state
type TContainerWaitRequest struct {
	// list of containers
	Name []string `protobuf:"bytes,1,rep,name=name" json:"name,omitempty"`
	// timeout, ms
	Timeout          *uint32 `protobuf:"varint,2,opt,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerWaitRequest) Reset()         { *m = TContainerWaitRequest{} }
func (m *TContainerWaitRequest) String() string { return proto.CompactTextString(m) }
func (*TContainerWaitRequest) ProtoMessage()    {}

func (m *TContainerWaitRequest) GetName() []string {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *TContainerWaitRequest) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

// Move process into container
type TAttachProcessRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Pid              *uint32 `protobuf:"varint,2,req,name=pid" json:"pid,omitempty"`
	Comm             *string `protobuf:"bytes,3,req,name=comm" json:"comm,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TAttachProcessRequest) Reset()         { *m = TAttachProcessRequest{} }
func (m *TAttachProcessRequest) String() string { return proto.CompactTextString(m) }
func (*TAttachProcessRequest) ProtoMessage()    {}

func (m *TAttachProcessRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TAttachProcessRequest) GetPid() uint32 {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return 0
}

func (m *TAttachProcessRequest) GetComm() string {
	if m != nil && m.Comm != nil {
		return *m.Comm
	}
	return ""
}

type TPortoRequest struct {
	Create               *TContainerCreateRequest       `protobuf:"bytes,1,opt,name=create" json:"create,omitempty"`
	Destroy              *TContainerDestroyRequest      `protobuf:"bytes,2,opt,name=destroy" json:"destroy,omitempty"`
	List                 *TContainerListRequest         `protobuf:"bytes,3,opt,name=list" json:"list,omitempty"`
	GetProperty          *TContainerGetPropertyRequest  `protobuf:"bytes,4,opt,name=getProperty" json:"getProperty,omitempty"`
	SetProperty          *TContainerSetPropertyRequest  `protobuf:"bytes,5,opt,name=setProperty" json:"setProperty,omitempty"`
	GetData              *TContainerGetDataRequest      `protobuf:"bytes,6,opt,name=getData" json:"getData,omitempty"`
	Start                *TContainerStartRequest        `protobuf:"bytes,7,opt,name=start" json:"start,omitempty"`
	Stop                 *TContainerStopRequest         `protobuf:"bytes,8,opt,name=stop" json:"stop,omitempty"`
	Pause                *TContainerPauseRequest        `protobuf:"bytes,9,opt,name=pause" json:"pause,omitempty"`
	Resume               *TContainerResumeRequest       `protobuf:"bytes,10,opt,name=resume" json:"resume,omitempty"`
	PropertyList         *TContainerPropertyListRequest `protobuf:"bytes,11,opt,name=propertyList" json:"propertyList,omitempty"`
	DataList             *TContainerDataListRequest     `protobuf:"bytes,12,opt,name=dataList" json:"dataList,omitempty"`
	Kill                 *TContainerKillRequest         `protobuf:"bytes,13,opt,name=kill" json:"kill,omitempty"`
	Version              *TVersionRequest               `protobuf:"bytes,14,opt,name=version" json:"version,omitempty"`
	Get                  *TContainerGetRequest          `protobuf:"bytes,15,opt,name=get" json:"get,omitempty"`
	Wait                 *TContainerWaitRequest         `protobuf:"bytes,16,opt,name=wait" json:"wait,omitempty"`
	CreateWeak           *TContainerCreateRequest       `protobuf:"bytes,17,opt,name=createWeak" json:"createWeak,omitempty"`
	ListVolumeProperties *TVolumePropertyListRequest    `protobuf:"bytes,103,opt,name=listVolumeProperties" json:"listVolumeProperties,omitempty"`
	CreateVolume         *TVolumeCreateRequest          `protobuf:"bytes,104,opt,name=createVolume" json:"createVolume,omitempty"`
	LinkVolume           *TVolumeLinkRequest            `protobuf:"bytes,105,opt,name=linkVolume" json:"linkVolume,omitempty"`
	UnlinkVolume         *TVolumeUnlinkRequest          `protobuf:"bytes,106,opt,name=unlinkVolume" json:"unlinkVolume,omitempty"`
	ListVolumes          *TVolumeListRequest            `protobuf:"bytes,107,opt,name=listVolumes" json:"listVolumes,omitempty"`
	TuneVolume           *TVolumeTuneRequest            `protobuf:"bytes,108,opt,name=tuneVolume" json:"tuneVolume,omitempty"`
	ImportLayer          *TLayerImportRequest           `protobuf:"bytes,110,opt,name=importLayer" json:"importLayer,omitempty"`
	RemoveLayer          *TLayerRemoveRequest           `protobuf:"bytes,111,opt,name=removeLayer" json:"removeLayer,omitempty"`
	ListLayers           *TLayerListRequest             `protobuf:"bytes,112,opt,name=listLayers" json:"listLayers,omitempty"`
	ExportLayer          *TLayerExportRequest           `protobuf:"bytes,113,opt,name=exportLayer" json:"exportLayer,omitempty"`
	Getlayerprivate      *TLayerGetPrivateRequest       `protobuf:"bytes,114,opt,name=getlayerprivate" json:"getlayerprivate,omitempty"`
	Setlayerprivate      *TLayerSetPrivateRequest       `protobuf:"bytes,115,opt,name=setlayerprivate" json:"setlayerprivate,omitempty"`
	ListStorage          *TStorageListRequest           `protobuf:"bytes,116,opt,name=listStorage" json:"listStorage,omitempty"`
	RemoveStorage        *TStorageRemoveRequest         `protobuf:"bytes,117,opt,name=removeStorage" json:"removeStorage,omitempty"`
	ImportStorage        *TStorageImportRequest         `protobuf:"bytes,118,opt,name=importStorage" json:"importStorage,omitempty"`
	ExportStorage        *TStorageExportRequest         `protobuf:"bytes,119,opt,name=exportStorage" json:"exportStorage,omitempty"`
	ConvertPath          *TConvertPathRequest           `protobuf:"bytes,200,opt,name=convertPath" json:"convertPath,omitempty"`
	AttachProcess        *TAttachProcessRequest         `protobuf:"bytes,201,opt,name=attachProcess" json:"attachProcess,omitempty"`
	XXX_unrecognized     []byte                         `json:"-"`
}

func (m *TPortoRequest) Reset()         { *m = TPortoRequest{} }
func (m *TPortoRequest) String() string { return proto.CompactTextString(m) }
func (*TPortoRequest) ProtoMessage()    {}

func (m *TPortoRequest) GetCreate() *TContainerCreateRequest {
	if m != nil {
		return m.Create
	}
	return nil
}

func (m *TPortoRequest) GetDestroy() *TContainerDestroyRequest {
	if m != nil {
		return m.Destroy
	}
	return nil
}

func (m *TPortoRequest) GetList() *TContainerListRequest {
	if m != nil {
		return m.List
	}
	return nil
}

func (m *TPortoRequest) GetGetProperty() *TContainerGetPropertyRequest {
	if m != nil {
		return m.GetProperty
	}
	return nil
}

func (m *TPortoRequest) GetSetProperty() *TContainerSetPropertyRequest {
	if m != nil {
		return m.SetProperty
	}
	return nil
}

func (m *TPortoRequest) GetGetData() *TContainerGetDataRequest {
	if m != nil {
		return m.GetData
	}
	return nil
}

func (m *TPortoRequest) GetStart() *TContainerStartRequest {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *TPortoRequest) GetStop() *TContainerStopRequest {
	if m != nil {
		return m.Stop
	}
	return nil
}

func (m *TPortoRequest) GetPause() *TContainerPauseRequest {
	if m != nil {
		return m.Pause
	}
	return nil
}

func (m *TPortoRequest) GetResume() *TContainerResumeRequest {
	if m != nil {
		return m.Resume
	}
	return nil
}

func (m *TPortoRequest) GetPropertyList() *TContainerPropertyListRequest {
	if m != nil {
		return m.PropertyList
	}
	return nil
}

func (m *TPortoRequest) GetDataList() *TContainerDataListRequest {
	if m != nil {
		return m.DataList
	}
	return nil
}

func (m *TPortoRequest) GetKill() *TContainerKillRequest {
	if m != nil {
		return m.Kill
	}
	return nil
}

func (m *TPortoRequest) GetVersion() *TVersionRequest {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *TPortoRequest) GetGet() *TContainerGetRequest {
	if m != nil {
		return m.Get
	}
	return nil
}

func (m *TPortoRequest) GetWait() *TContainerWaitRequest {
	if m != nil {
		return m.Wait
	}
	return nil
}

func (m *TPortoRequest) GetCreateWeak() *TContainerCreateRequest {
	if m != nil {
		return m.CreateWeak
	}
	return nil
}

func (m *TPortoRequest) GetListVolumeProperties() *TVolumePropertyListRequest {
	if m != nil {
		return m.ListVolumeProperties
	}
	return nil
}

func (m *TPortoRequest) GetCreateVolume() *TVolumeCreateRequest {
	if m != nil {
		return m.CreateVolume
	}
	return nil
}

func (m *TPortoRequest) GetLinkVolume() *TVolumeLinkRequest {
	if m != nil {
		return m.LinkVolume
	}
	return nil
}

func (m *TPortoRequest) GetUnlinkVolume() *TVolumeUnlinkRequest {
	if m != nil {
		return m.UnlinkVolume
	}
	return nil
}

func (m *TPortoRequest) GetListVolumes() *TVolumeListRequest {
	if m != nil {
		return m.ListVolumes
	}
	return nil
}

func (m *TPortoRequest) GetTuneVolume() *TVolumeTuneRequest {
	if m != nil {
		return m.TuneVolume
	}
	return nil
}

func (m *TPortoRequest) GetImportLayer() *TLayerImportRequest {
	if m != nil {
		return m.ImportLayer
	}
	return nil
}

func (m *TPortoRequest) GetRemoveLayer() *TLayerRemoveRequest {
	if m != nil {
		return m.RemoveLayer
	}
	return nil
}

func (m *TPortoRequest) GetListLayers() *TLayerListRequest {
	if m != nil {
		return m.ListLayers
	}
	return nil
}

func (m *TPortoRequest) GetExportLayer() *TLayerExportRequest {
	if m != nil {
		return m.ExportLayer
	}
	return nil
}

func (m *TPortoRequest) GetGetlayerprivate() *TLayerGetPrivateRequest {
	if m != nil {
		return m.Getlayerprivate
	}
	return nil
}

func (m *TPortoRequest) GetSetlayerprivate() *TLayerSetPrivateRequest {
	if m != nil {
		return m.Setlayerprivate
	}
	return nil
}

func (m *TPortoRequest) GetListStorage() *TStorageListRequest {
	if m != nil {
		return m.ListStorage
	}
	return nil
}

func (m *TPortoRequest) GetRemoveStorage() *TStorageRemoveRequest {
	if m != nil {
		return m.RemoveStorage
	}
	return nil
}

func (m *TPortoRequest) GetImportStorage() *TStorageImportRequest {
	if m != nil {
		return m.ImportStorage
	}
	return nil
}

func (m *TPortoRequest) GetExportStorage() *TStorageExportRequest {
	if m != nil {
		return m.ExportStorage
	}
	return nil
}

func (m *TPortoRequest) GetConvertPath() *TConvertPathRequest {
	if m != nil {
		return m.ConvertPath
	}
	return nil
}

func (m *TPortoRequest) GetAttachProcess() *TAttachProcessRequest {
	if m != nil {
		return m.AttachProcess
	}
	return nil
}

type TContainerListResponse struct {
	Name             []string `protobuf:"bytes,1,rep,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TContainerListResponse) Reset()         { *m = TContainerListResponse{} }
func (m *TContainerListResponse) String() string { return proto.CompactTextString(m) }
func (*TContainerListResponse) ProtoMessage()    {}

func (m *TContainerListResponse) GetName() []string {
	if m != nil {
		return m.Name
	}
	return nil
}

type TContainerGetPropertyResponse struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerGetPropertyResponse) Reset()         { *m = TContainerGetPropertyResponse{} }
func (m *TContainerGetPropertyResponse) String() string { return proto.CompactTextString(m) }
func (*TContainerGetPropertyResponse) ProtoMessage()    {}

func (m *TContainerGetPropertyResponse) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type TContainerGetDataResponse struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerGetDataResponse) Reset()         { *m = TContainerGetDataResponse{} }
func (m *TContainerGetDataResponse) String() string { return proto.CompactTextString(m) }
func (*TContainerGetDataResponse) ProtoMessage()    {}

func (m *TContainerGetDataResponse) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type TContainerPropertyListResponse struct {
	List             []*TContainerPropertyListResponse_TContainerPropertyListEntry `protobuf:"bytes,1,rep,name=list" json:"list,omitempty"`
	XXX_unrecognized []byte                                                        `json:"-"`
}

func (m *TContainerPropertyListResponse) Reset()         { *m = TContainerPropertyListResponse{} }
func (m *TContainerPropertyListResponse) String() string { return proto.CompactTextString(m) }
func (*TContainerPropertyListResponse) ProtoMessage()    {}

func (m *TContainerPropertyListResponse) GetList() []*TContainerPropertyListResponse_TContainerPropertyListEntry {
	if m != nil {
		return m.List
	}
	return nil
}

type TContainerPropertyListResponse_TContainerPropertyListEntry struct {
	// Property name
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// Property description
	Desc             *string `protobuf:"bytes,2,req,name=desc" json:"desc,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerPropertyListResponse_TContainerPropertyListEntry) Reset() {
	*m = TContainerPropertyListResponse_TContainerPropertyListEntry{}
}
func (m *TContainerPropertyListResponse_TContainerPropertyListEntry) String() string {
	return proto.CompactTextString(m)
}
func (*TContainerPropertyListResponse_TContainerPropertyListEntry) ProtoMessage() {}

func (m *TContainerPropertyListResponse_TContainerPropertyListEntry) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerPropertyListResponse_TContainerPropertyListEntry) GetDesc() string {
	if m != nil && m.Desc != nil {
		return *m.Desc
	}
	return ""
}

type TContainerDataListResponse struct {
	List             []*TContainerDataListResponse_TContainerDataListEntry `protobuf:"bytes,1,rep,name=list" json:"list,omitempty"`
	XXX_unrecognized []byte                                                `json:"-"`
}

func (m *TContainerDataListResponse) Reset()         { *m = TContainerDataListResponse{} }
func (m *TContainerDataListResponse) String() string { return proto.CompactTextString(m) }
func (*TContainerDataListResponse) ProtoMessage()    {}

func (m *TContainerDataListResponse) GetList() []*TContainerDataListResponse_TContainerDataListEntry {
	if m != nil {
		return m.List
	}
	return nil
}

type TContainerDataListResponse_TContainerDataListEntry struct {
	// Data name
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// Data description
	Desc             *string `protobuf:"bytes,2,req,name=desc" json:"desc,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerDataListResponse_TContainerDataListEntry) Reset() {
	*m = TContainerDataListResponse_TContainerDataListEntry{}
}
func (m *TContainerDataListResponse_TContainerDataListEntry) String() string {
	return proto.CompactTextString(m)
}
func (*TContainerDataListResponse_TContainerDataListEntry) ProtoMessage() {}

func (m *TContainerDataListResponse_TContainerDataListEntry) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerDataListResponse_TContainerDataListEntry) GetDesc() string {
	if m != nil && m.Desc != nil {
		return *m.Desc
	}
	return ""
}

type TVersionResponse struct {
	Tag              *string `protobuf:"bytes,1,req,name=tag" json:"tag,omitempty"`
	Revision         *string `protobuf:"bytes,2,req,name=revision" json:"revision,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TVersionResponse) Reset()         { *m = TVersionResponse{} }
func (m *TVersionResponse) String() string { return proto.CompactTextString(m) }
func (*TVersionResponse) ProtoMessage()    {}

func (m *TVersionResponse) GetTag() string {
	if m != nil && m.Tag != nil {
		return *m.Tag
	}
	return ""
}

func (m *TVersionResponse) GetRevision() string {
	if m != nil && m.Revision != nil {
		return *m.Revision
	}
	return ""
}

type TContainerGetResponse struct {
	List             []*TContainerGetResponse_TContainerGetListResponse `protobuf:"bytes,1,rep,name=list" json:"list,omitempty"`
	XXX_unrecognized []byte                                             `json:"-"`
}

func (m *TContainerGetResponse) Reset()         { *m = TContainerGetResponse{} }
func (m *TContainerGetResponse) String() string { return proto.CompactTextString(m) }
func (*TContainerGetResponse) ProtoMessage()    {}

func (m *TContainerGetResponse) GetList() []*TContainerGetResponse_TContainerGetListResponse {
	if m != nil {
		return m.List
	}
	return nil
}

type TContainerGetResponse_TContainerGetValueResponse struct {
	Variable         *string `protobuf:"bytes,1,req,name=variable" json:"variable,omitempty"`
	Error            *EError `protobuf:"varint,2,opt,name=error,enum=rpc.EError" json:"error,omitempty"`
	ErrorMsg         *string `protobuf:"bytes,3,opt,name=errorMsg" json:"errorMsg,omitempty"`
	Value            *string `protobuf:"bytes,4,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerGetResponse_TContainerGetValueResponse) Reset() {
	*m = TContainerGetResponse_TContainerGetValueResponse{}
}
func (m *TContainerGetResponse_TContainerGetValueResponse) String() string {
	return proto.CompactTextString(m)
}
func (*TContainerGetResponse_TContainerGetValueResponse) ProtoMessage() {}

func (m *TContainerGetResponse_TContainerGetValueResponse) GetVariable() string {
	if m != nil && m.Variable != nil {
		return *m.Variable
	}
	return ""
}

func (m *TContainerGetResponse_TContainerGetValueResponse) GetError() EError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return EError_Success
}

func (m *TContainerGetResponse_TContainerGetValueResponse) GetErrorMsg() string {
	if m != nil && m.ErrorMsg != nil {
		return *m.ErrorMsg
	}
	return ""
}

func (m *TContainerGetResponse_TContainerGetValueResponse) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type TContainerGetResponse_TContainerGetListResponse struct {
	Name             *string                                             `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Keyval           []*TContainerGetResponse_TContainerGetValueResponse `protobuf:"bytes,2,rep,name=keyval" json:"keyval,omitempty"`
	XXX_unrecognized []byte                                              `json:"-"`
}

func (m *TContainerGetResponse_TContainerGetListResponse) Reset() {
	*m = TContainerGetResponse_TContainerGetListResponse{}
}
func (m *TContainerGetResponse_TContainerGetListResponse) String() string {
	return proto.CompactTextString(m)
}
func (*TContainerGetResponse_TContainerGetListResponse) ProtoMessage() {}

func (m *TContainerGetResponse_TContainerGetListResponse) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TContainerGetResponse_TContainerGetListResponse) GetKeyval() []*TContainerGetResponse_TContainerGetValueResponse {
	if m != nil {
		return m.Keyval
	}
	return nil
}

type TContainerWaitResponse struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TContainerWaitResponse) Reset()         { *m = TContainerWaitResponse{} }
func (m *TContainerWaitResponse) String() string { return proto.CompactTextString(m) }
func (*TContainerWaitResponse) ProtoMessage()    {}

func (m *TContainerWaitResponse) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

type TConvertPathResponse struct {
	Path             *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TConvertPathResponse) Reset()         { *m = TConvertPathResponse{} }
func (m *TConvertPathResponse) String() string { return proto.CompactTextString(m) }
func (*TConvertPathResponse) ProtoMessage()    {}

func (m *TConvertPathResponse) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

type TPortoResponse struct {
	Error *EError `protobuf:"varint,1,req,name=error,enum=rpc.EError" json:"error,omitempty"`
	// Optional error message
	ErrorMsg           *string                         `protobuf:"bytes,2,opt,name=errorMsg" json:"errorMsg,omitempty"`
	List               *TContainerListResponse         `protobuf:"bytes,3,opt,name=list" json:"list,omitempty"`
	GetProperty        *TContainerGetPropertyResponse  `protobuf:"bytes,4,opt,name=getProperty" json:"getProperty,omitempty"`
	GetData            *TContainerGetDataResponse      `protobuf:"bytes,5,opt,name=getData" json:"getData,omitempty"`
	PropertyList       *TContainerPropertyListResponse `protobuf:"bytes,6,opt,name=propertyList" json:"propertyList,omitempty"`
	DataList           *TContainerDataListResponse     `protobuf:"bytes,7,opt,name=dataList" json:"dataList,omitempty"`
	Version            *TVersionResponse               `protobuf:"bytes,8,opt,name=version" json:"version,omitempty"`
	VolumeList         *TVolumeListResponse            `protobuf:"bytes,9,opt,name=volumeList" json:"volumeList,omitempty"`
	Get                *TContainerGetResponse          `protobuf:"bytes,10,opt,name=get" json:"get,omitempty"`
	Wait               *TContainerWaitResponse         `protobuf:"bytes,11,opt,name=wait" json:"wait,omitempty"`
	VolumePropertyList *TVolumePropertyListResponse    `protobuf:"bytes,12,opt,name=volumePropertyList" json:"volumePropertyList,omitempty"`
	Volume             *TVolumeDescription             `protobuf:"bytes,13,opt,name=volume" json:"volume,omitempty"`
	Layers             *TLayerListResponse             `protobuf:"bytes,14,opt,name=layers" json:"layers,omitempty"`
	ConvertPath        *TConvertPathResponse           `protobuf:"bytes,15,opt,name=convertPath" json:"convertPath,omitempty"`
	LayerPrivate       *TLayerGetPrivateResponse       `protobuf:"bytes,16,opt,name=layer_private" json:"layer_private,omitempty"`
	StorageList        *TStorageListResponse           `protobuf:"bytes,17,opt,name=storageList" json:"storageList,omitempty"`
	XXX_unrecognized   []byte                          `json:"-"`
}

func (m *TPortoResponse) Reset()         { *m = TPortoResponse{} }
func (m *TPortoResponse) String() string { return proto.CompactTextString(m) }
func (*TPortoResponse) ProtoMessage()    {}

func (m *TPortoResponse) GetError() EError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return EError_Success
}

func (m *TPortoResponse) GetErrorMsg() string {
	if m != nil && m.ErrorMsg != nil {
		return *m.ErrorMsg
	}
	return ""
}

func (m *TPortoResponse) GetList() *TContainerListResponse {
	if m != nil {
		return m.List
	}
	return nil
}

func (m *TPortoResponse) GetGetProperty() *TContainerGetPropertyResponse {
	if m != nil {
		return m.GetProperty
	}
	return nil
}

func (m *TPortoResponse) GetGetData() *TContainerGetDataResponse {
	if m != nil {
		return m.GetData
	}
	return nil
}

func (m *TPortoResponse) GetPropertyList() *TContainerPropertyListResponse {
	if m != nil {
		return m.PropertyList
	}
	return nil
}

func (m *TPortoResponse) GetDataList() *TContainerDataListResponse {
	if m != nil {
		return m.DataList
	}
	return nil
}

func (m *TPortoResponse) GetVersion() *TVersionResponse {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *TPortoResponse) GetVolumeList() *TVolumeListResponse {
	if m != nil {
		return m.VolumeList
	}
	return nil
}

func (m *TPortoResponse) GetGet() *TContainerGetResponse {
	if m != nil {
		return m.Get
	}
	return nil
}

func (m *TPortoResponse) GetWait() *TContainerWaitResponse {
	if m != nil {
		return m.Wait
	}
	return nil
}

func (m *TPortoResponse) GetVolumePropertyList() *TVolumePropertyListResponse {
	if m != nil {
		return m.VolumePropertyList
	}
	return nil
}

func (m *TPortoResponse) GetVolume() *TVolumeDescription {
	if m != nil {
		return m.Volume
	}
	return nil
}

func (m *TPortoResponse) GetLayers() *TLayerListResponse {
	if m != nil {
		return m.Layers
	}
	return nil
}

func (m *TPortoResponse) GetConvertPath() *TConvertPathResponse {
	if m != nil {
		return m.ConvertPath
	}
	return nil
}

func (m *TPortoResponse) GetLayerPrivate() *TLayerGetPrivateResponse {
	if m != nil {
		return m.LayerPrivate
	}
	return nil
}

func (m *TPortoResponse) GetStorageList() *TStorageListResponse {
	if m != nil {
		return m.StorageList
	}
	return nil
}

type TVolumeProperty struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TVolumeProperty) Reset()         { *m = TVolumeProperty{} }
func (m *TVolumeProperty) String() string { return proto.CompactTextString(m) }
func (*TVolumeProperty) ProtoMessage()    {}

func (m *TVolumeProperty) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TVolumeProperty) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type TVolumePropertyDescription struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Desc             *string `protobuf:"bytes,2,req,name=desc" json:"desc,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TVolumePropertyDescription) Reset()         { *m = TVolumePropertyDescription{} }
func (m *TVolumePropertyDescription) String() string { return proto.CompactTextString(m) }
func (*TVolumePropertyDescription) ProtoMessage()    {}

func (m *TVolumePropertyDescription) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TVolumePropertyDescription) GetDesc() string {
	if m != nil && m.Desc != nil {
		return *m.Desc
	}
	return ""
}

type TVolumeDescription struct {
	Path             *string            `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Properties       []*TVolumeProperty `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty"`
	Containers       []string           `protobuf:"bytes,3,rep,name=containers" json:"containers,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *TVolumeDescription) Reset()         { *m = TVolumeDescription{} }
func (m *TVolumeDescription) String() string { return proto.CompactTextString(m) }
func (*TVolumeDescription) ProtoMessage()    {}

func (m *TVolumeDescription) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *TVolumeDescription) GetProperties() []*TVolumeProperty {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *TVolumeDescription) GetContainers() []string {
	if m != nil {
		return m.Containers
	}
	return nil
}

type TVolumePropertyListRequest struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TVolumePropertyListRequest) Reset()         { *m = TVolumePropertyListRequest{} }
func (m *TVolumePropertyListRequest) String() string { return proto.CompactTextString(m) }
func (*TVolumePropertyListRequest) ProtoMessage()    {}

type TVolumePropertyListResponse struct {
	Properties       []*TVolumePropertyDescription `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *TVolumePropertyListResponse) Reset()         { *m = TVolumePropertyListResponse{} }
func (m *TVolumePropertyListResponse) String() string { return proto.CompactTextString(m) }
func (*TVolumePropertyListResponse) ProtoMessage()    {}

func (m *TVolumePropertyListResponse) GetProperties() []*TVolumePropertyDescription {
	if m != nil {
		return m.Properties
	}
	return nil
}

type TVolumeCreateRequest struct {
	Path             *string            `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Properties       []*TVolumeProperty `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *TVolumeCreateRequest) Reset()         { *m = TVolumeCreateRequest{} }
func (m *TVolumeCreateRequest) String() string { return proto.CompactTextString(m) }
func (*TVolumeCreateRequest) ProtoMessage()    {}

func (m *TVolumeCreateRequest) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *TVolumeCreateRequest) GetProperties() []*TVolumeProperty {
	if m != nil {
		return m.Properties
	}
	return nil
}

type TVolumeLinkRequest struct {
	Path             *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Container        *string `protobuf:"bytes,2,opt,name=container" json:"container,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TVolumeLinkRequest) Reset()         { *m = TVolumeLinkRequest{} }
func (m *TVolumeLinkRequest) String() string { return proto.CompactTextString(m) }
func (*TVolumeLinkRequest) ProtoMessage()    {}

func (m *TVolumeLinkRequest) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *TVolumeLinkRequest) GetContainer() string {
	if m != nil && m.Container != nil {
		return *m.Container
	}
	return ""
}

type TVolumeUnlinkRequest struct {
	Path             *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Container        *string `protobuf:"bytes,2,opt,name=container" json:"container,omitempty"`
	Strict           *bool   `protobuf:"varint,3,opt,name=strict" json:"strict,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TVolumeUnlinkRequest) Reset()         { *m = TVolumeUnlinkRequest{} }
func (m *TVolumeUnlinkRequest) String() string { return proto.CompactTextString(m) }
func (*TVolumeUnlinkRequest) ProtoMessage()    {}

func (m *TVolumeUnlinkRequest) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *TVolumeUnlinkRequest) GetContainer() string {
	if m != nil && m.Container != nil {
		return *m.Container
	}
	return ""
}

func (m *TVolumeUnlinkRequest) GetStrict() bool {
	if m != nil && m.Strict != nil {
		return *m.Strict
	}
	return false
}

type TVolumeListRequest struct {
	Path             *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Container        *string `protobuf:"bytes,2,opt,name=container" json:"container,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TVolumeListRequest) Reset()         { *m = TVolumeListRequest{} }
func (m *TVolumeListRequest) String() string { return proto.CompactTextString(m) }
func (*TVolumeListRequest) ProtoMessage()    {}

func (m *TVolumeListRequest) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *TVolumeListRequest) GetContainer() string {
	if m != nil && m.Container != nil {
		return *m.Container
	}
	return ""
}

type TVolumeTuneRequest struct {
	Path             *string            `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Properties       []*TVolumeProperty `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *TVolumeTuneRequest) Reset()         { *m = TVolumeTuneRequest{} }
func (m *TVolumeTuneRequest) String() string { return proto.CompactTextString(m) }
func (*TVolumeTuneRequest) ProtoMessage()    {}

func (m *TVolumeTuneRequest) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *TVolumeTuneRequest) GetProperties() []*TVolumeProperty {
	if m != nil {
		return m.Properties
	}
	return nil
}

type TVolumeListResponse struct {
	Volumes          []*TVolumeDescription `protobuf:"bytes,1,rep,name=volumes" json:"volumes,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *TVolumeListResponse) Reset()         { *m = TVolumeListResponse{} }
func (m *TVolumeListResponse) String() string { return proto.CompactTextString(m) }
func (*TVolumeListResponse) ProtoMessage()    {}

func (m *TVolumeListResponse) GetVolumes() []*TVolumeDescription {
	if m != nil {
		return m.Volumes
	}
	return nil
}

type TLayerImportRequest struct {
	Layer            *string `protobuf:"bytes,1,req,name=layer" json:"layer,omitempty"`
	Tarball          *string `protobuf:"bytes,2,req,name=tarball" json:"tarball,omitempty"`
	Merge            *bool   `protobuf:"varint,3,req,name=merge" json:"merge,omitempty"`
	Place            *string `protobuf:"bytes,4,opt,name=place" json:"place,omitempty"`
	PrivateValue     *string `protobuf:"bytes,5,opt,name=private_value" json:"private_value,omitempty"`
	Compress         *string `protobuf:"bytes,6,opt,name=compress" json:"compress,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerImportRequest) Reset()         { *m = TLayerImportRequest{} }
func (m *TLayerImportRequest) String() string { return proto.CompactTextString(m) }
func (*TLayerImportRequest) ProtoMessage()    {}

func (m *TLayerImportRequest) GetLayer() string {
	if m != nil && m.Layer != nil {
		return *m.Layer
	}
	return ""
}

func (m *TLayerImportRequest) GetTarball() string {
	if m != nil && m.Tarball != nil {
		return *m.Tarball
	}
	return ""
}

func (m *TLayerImportRequest) GetMerge() bool {
	if m != nil && m.Merge != nil {
		return *m.Merge
	}
	return false
}

func (m *TLayerImportRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

func (m *TLayerImportRequest) GetPrivateValue() string {
	if m != nil && m.PrivateValue != nil {
		return *m.PrivateValue
	}
	return ""
}

func (m *TLayerImportRequest) GetCompress() string {
	if m != nil && m.Compress != nil {
		return *m.Compress
	}
	return ""
}

type TLayerExportRequest struct {
	Volume           *string `protobuf:"bytes,1,req,name=volume" json:"volume,omitempty"`
	Tarball          *string `protobuf:"bytes,2,req,name=tarball" json:"tarball,omitempty"`
	Layer            *string `protobuf:"bytes,3,opt,name=layer" json:"layer,omitempty"`
	Place            *string `protobuf:"bytes,4,opt,name=place" json:"place,omitempty"`
	Compress         *string `protobuf:"bytes,5,opt,name=compress" json:"compress,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerExportRequest) Reset()         { *m = TLayerExportRequest{} }
func (m *TLayerExportRequest) String() string { return proto.CompactTextString(m) }
func (*TLayerExportRequest) ProtoMessage()    {}

func (m *TLayerExportRequest) GetVolume() string {
	if m != nil && m.Volume != nil {
		return *m.Volume
	}
	return ""
}

func (m *TLayerExportRequest) GetTarball() string {
	if m != nil && m.Tarball != nil {
		return *m.Tarball
	}
	return ""
}

func (m *TLayerExportRequest) GetLayer() string {
	if m != nil && m.Layer != nil {
		return *m.Layer
	}
	return ""
}

func (m *TLayerExportRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

func (m *TLayerExportRequest) GetCompress() string {
	if m != nil && m.Compress != nil {
		return *m.Compress
	}
	return ""
}

type TLayerRemoveRequest struct {
	Layer            *string `protobuf:"bytes,1,req,name=layer" json:"layer,omitempty"`
	Place            *string `protobuf:"bytes,2,opt,name=place" json:"place,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerRemoveRequest) Reset()         { *m = TLayerRemoveRequest{} }
func (m *TLayerRemoveRequest) String() string { return proto.CompactTextString(m) }
func (*TLayerRemoveRequest) ProtoMessage()    {}

func (m *TLayerRemoveRequest) GetLayer() string {
	if m != nil && m.Layer != nil {
		return *m.Layer
	}
	return ""
}

func (m *TLayerRemoveRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

type TLayerListRequest struct {
	Place            *string `protobuf:"bytes,1,opt,name=place" json:"place,omitempty"`
	Mask             *string `protobuf:"bytes,2,opt,name=mask" json:"mask,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerListRequest) Reset()         { *m = TLayerListRequest{} }
func (m *TLayerListRequest) String() string { return proto.CompactTextString(m) }
func (*TLayerListRequest) ProtoMessage()    {}

func (m *TLayerListRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

func (m *TLayerListRequest) GetMask() string {
	if m != nil && m.Mask != nil {
		return *m.Mask
	}
	return ""
}

type TLayerGetPrivateRequest struct {
	Layer            *string `protobuf:"bytes,1,req,name=layer" json:"layer,omitempty"`
	Place            *string `protobuf:"bytes,2,opt,name=place" json:"place,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerGetPrivateRequest) Reset()         { *m = TLayerGetPrivateRequest{} }
func (m *TLayerGetPrivateRequest) String() string { return proto.CompactTextString(m) }
func (*TLayerGetPrivateRequest) ProtoMessage()    {}

func (m *TLayerGetPrivateRequest) GetLayer() string {
	if m != nil && m.Layer != nil {
		return *m.Layer
	}
	return ""
}

func (m *TLayerGetPrivateRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

type TLayerSetPrivateRequest struct {
	Layer            *string `protobuf:"bytes,1,req,name=layer" json:"layer,omitempty"`
	Place            *string `protobuf:"bytes,2,opt,name=place" json:"place,omitempty"`
	PrivateValue     *string `protobuf:"bytes,3,req,name=private_value" json:"private_value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerSetPrivateRequest) Reset()         { *m = TLayerSetPrivateRequest{} }
func (m *TLayerSetPrivateRequest) String() string { return proto.CompactTextString(m) }
func (*TLayerSetPrivateRequest) ProtoMessage()    {}

func (m *TLayerSetPrivateRequest) GetLayer() string {
	if m != nil && m.Layer != nil {
		return *m.Layer
	}
	return ""
}

func (m *TLayerSetPrivateRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

func (m *TLayerSetPrivateRequest) GetPrivateValue() string {
	if m != nil && m.PrivateValue != nil {
		return *m.PrivateValue
	}
	return ""
}

type TLayerDescription struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	OwnerUser        *string `protobuf:"bytes,2,req,name=owner_user" json:"owner_user,omitempty"`
	OwnerGroup       *string `protobuf:"bytes,3,req,name=owner_group" json:"owner_group,omitempty"`
	LastUsage        *uint64 `protobuf:"varint,4,req,name=last_usage" json:"last_usage,omitempty"`
	PrivateValue     *string `protobuf:"bytes,5,req,name=private_value" json:"private_value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerDescription) Reset()         { *m = TLayerDescription{} }
func (m *TLayerDescription) String() string { return proto.CompactTextString(m) }
func (*TLayerDescription) ProtoMessage()    {}

func (m *TLayerDescription) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TLayerDescription) GetOwnerUser() string {
	if m != nil && m.OwnerUser != nil {
		return *m.OwnerUser
	}
	return ""
}

func (m *TLayerDescription) GetOwnerGroup() string {
	if m != nil && m.OwnerGroup != nil {
		return *m.OwnerGroup
	}
	return ""
}

func (m *TLayerDescription) GetLastUsage() uint64 {
	if m != nil && m.LastUsage != nil {
		return *m.LastUsage
	}
	return 0
}

func (m *TLayerDescription) GetPrivateValue() string {
	if m != nil && m.PrivateValue != nil {
		return *m.PrivateValue
	}
	return ""
}

type TLayerListResponse struct {
	Layer            []string             `protobuf:"bytes,1,rep,name=layer" json:"layer,omitempty"`
	Layers           []*TLayerDescription `protobuf:"bytes,2,rep,name=layers" json:"layers,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *TLayerListResponse) Reset()         { *m = TLayerListResponse{} }
func (m *TLayerListResponse) String() string { return proto.CompactTextString(m) }
func (*TLayerListResponse) ProtoMessage()    {}

func (m *TLayerListResponse) GetLayer() []string {
	if m != nil {
		return m.Layer
	}
	return nil
}

func (m *TLayerListResponse) GetLayers() []*TLayerDescription {
	if m != nil {
		return m.Layers
	}
	return nil
}

type TLayerGetPrivateResponse struct {
	PrivateValue     *string `protobuf:"bytes,1,opt,name=private_value" json:"private_value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TLayerGetPrivateResponse) Reset()         { *m = TLayerGetPrivateResponse{} }
func (m *TLayerGetPrivateResponse) String() string { return proto.CompactTextString(m) }
func (*TLayerGetPrivateResponse) ProtoMessage()    {}

func (m *TLayerGetPrivateResponse) GetPrivateValue() string {
	if m != nil && m.PrivateValue != nil {
		return *m.PrivateValue
	}
	return ""
}

type TStorageDescription struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	OwnerUser        *string `protobuf:"bytes,2,req,name=owner_user" json:"owner_user,omitempty"`
	OwnerGroup       *string `protobuf:"bytes,3,req,name=owner_group" json:"owner_group,omitempty"`
	LastUsage        *uint64 `protobuf:"varint,4,req,name=last_usage" json:"last_usage,omitempty"`
	PrivateValue     *string `protobuf:"bytes,5,req,name=private_value" json:"private_value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TStorageDescription) Reset()         { *m = TStorageDescription{} }
func (m *TStorageDescription) String() string { return proto.CompactTextString(m) }
func (*TStorageDescription) ProtoMessage()    {}

func (m *TStorageDescription) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TStorageDescription) GetOwnerUser() string {
	if m != nil && m.OwnerUser != nil {
		return *m.OwnerUser
	}
	return ""
}

func (m *TStorageDescription) GetOwnerGroup() string {
	if m != nil && m.OwnerGroup != nil {
		return *m.OwnerGroup
	}
	return ""
}

func (m *TStorageDescription) GetLastUsage() uint64 {
	if m != nil && m.LastUsage != nil {
		return *m.LastUsage
	}
	return 0
}

func (m *TStorageDescription) GetPrivateValue() string {
	if m != nil && m.PrivateValue != nil {
		return *m.PrivateValue
	}
	return ""
}

type TStorageListRequest struct {
	Place            *string `protobuf:"bytes,1,opt,name=place" json:"place,omitempty"`
	Mask             *string `protobuf:"bytes,2,opt,name=mask" json:"mask,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TStorageListRequest) Reset()         { *m = TStorageListRequest{} }
func (m *TStorageListRequest) String() string { return proto.CompactTextString(m) }
func (*TStorageListRequest) ProtoMessage()    {}

func (m *TStorageListRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

func (m *TStorageListRequest) GetMask() string {
	if m != nil && m.Mask != nil {
		return *m.Mask
	}
	return ""
}

type TStorageListResponse struct {
	Storages         []*TStorageDescription `protobuf:"bytes,1,rep,name=storages" json:"storages,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *TStorageListResponse) Reset()         { *m = TStorageListResponse{} }
func (m *TStorageListResponse) String() string { return proto.CompactTextString(m) }
func (*TStorageListResponse) ProtoMessage()    {}

func (m *TStorageListResponse) GetStorages() []*TStorageDescription {
	if m != nil {
		return m.Storages
	}
	return nil
}

type TStorageRemoveRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Place            *string `protobuf:"bytes,2,opt,name=place" json:"place,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TStorageRemoveRequest) Reset()         { *m = TStorageRemoveRequest{} }
func (m *TStorageRemoveRequest) String() string { return proto.CompactTextString(m) }
func (*TStorageRemoveRequest) ProtoMessage()    {}

func (m *TStorageRemoveRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TStorageRemoveRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

type TStorageImportRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Tarball          *string `protobuf:"bytes,2,req,name=tarball" json:"tarball,omitempty"`
	Place            *string `protobuf:"bytes,3,opt,name=place" json:"place,omitempty"`
	PrivateValue     *string `protobuf:"bytes,5,opt,name=private_value" json:"private_value,omitempty"`
	Compress         *string `protobuf:"bytes,6,opt,name=compress" json:"compress,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TStorageImportRequest) Reset()         { *m = TStorageImportRequest{} }
func (m *TStorageImportRequest) String() string { return proto.CompactTextString(m) }
func (*TStorageImportRequest) ProtoMessage()    {}

func (m *TStorageImportRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TStorageImportRequest) GetTarball() string {
	if m != nil && m.Tarball != nil {
		return *m.Tarball
	}
	return ""
}

func (m *TStorageImportRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

func (m *TStorageImportRequest) GetPrivateValue() string {
	if m != nil && m.PrivateValue != nil {
		return *m.PrivateValue
	}
	return ""
}

func (m *TStorageImportRequest) GetCompress() string {
	if m != nil && m.Compress != nil {
		return *m.Compress
	}
	return ""
}

type TStorageExportRequest struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Tarball          *string `protobuf:"bytes,2,req,name=tarball" json:"tarball,omitempty"`
	Place            *string `protobuf:"bytes,3,opt,name=place" json:"place,omitempty"`
	Compress         *string `protobuf:"bytes,4,opt,name=compress" json:"compress,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TStorageExportRequest) Reset()         { *m = TStorageExportRequest{} }
func (m *TStorageExportRequest) String() string { return proto.CompactTextString(m) }
func (*TStorageExportRequest) ProtoMessage()    {}

func (m *TStorageExportRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TStorageExportRequest) GetTarball() string {
	if m != nil && m.Tarball != nil {
		return *m.Tarball
	}
	return ""
}

func (m *TStorageExportRequest) GetPlace() string {
	if m != nil && m.Place != nil {
		return *m.Place
	}
	return ""
}

func (m *TStorageExportRequest) GetCompress() string {
	if m != nil && m.Compress != nil {
		return *m.Compress
	}
	return ""
}

func init() {
	proto.RegisterEnum("rpc.EError", EError_name, EError_value)
}
