package samples

import (
	"io/ioutil"

	pb "a.yandex-team.ru/mds/valve/proto"
	"github.com/golang/protobuf/proto"
	"go.uber.org/zap"
)

func WriteProtoMessageToFile(dstPath string, pb proto.Message) error {
	zap.S().Debugf("Writing proto message to %s\n", dstPath)
	b, err := proto.Marshal(pb)
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(dstPath, b, 0644)
	if err != nil {
		return err
	}
	return nil
}

func ReadProtoMessageFromFile(readPath string, pb proto.Message) error {
	zap.S().Debugf("Reading proto message from %s\n", readPath)
	b, err := ioutil.ReadFile(readPath)
	if err != nil {
		return err
	}
	err = proto.Unmarshal(b, pb)
	if err != nil {
		return err
	}
	return nil
}

func ReadOldSample(path string) (*pb.NetSample, error) {
	oldFullSample := &pb.NetSample{}
	err := ReadProtoMessageFromFile(path, oldFullSample)
	if err != nil {
		zap.S().Debugf("Could not read old dump: %s", err)
		return nil, err
	}
	return oldFullSample, nil
}
