package samples

import (
	"net"
	"reflect"
	"testing"

	pb "a.yandex-team.ru/mds/valve/proto"
)

func TestFilter(t *testing.T) {
	oldNsMap := make(map[string]*pb.NetNSSample)
	newNsMap := make(map[string]*pb.NetNSSample)

	sample1 := &pb.TCPSample{
		SrcAddr: net.ParseIP("2001:DB8::1"),
		DstAddr: net.ParseIP("2001:DB8::100"),
		SrcPort: 57000,
		DstPort: 80,
		Iface:   "L3-1",
		Chain:   pb.Chain_OUTPUT,
		Tcpi:    &pb.TCPInfo{SegsIn: 10, SegsOut: 11},
	}

	sample2 := &pb.TCPSample{
		SrcAddr: net.ParseIP("2001:DB8::2"),
		DstAddr: net.ParseIP("2001:DB8::200"),
		SrcPort: 50000,
		DstPort: 443,
		Iface:   "L3-2",
		Chain:   pb.Chain_OUTPUT,
		Tcpi:    &pb.TCPInfo{SegsIn: 8, SegsOut: 9},
	}

	sample3 := &pb.TCPSample{
		SrcAddr: net.ParseIP("2001:DB8::3"),
		DstAddr: net.ParseIP("2001:DB8::300"),
		SrcPort: 443,
		DstPort: 50000,
		Iface:   "L3-3",
		Chain:   pb.Chain_INPUT,
		Tcpi:    &pb.TCPInfo{SegsIn: 10, SegsOut: 11},
	}

	sample4 := &pb.TCPSample{
		SrcAddr: net.ParseIP("2001:DB8::2"),
		DstAddr: net.ParseIP("2001:DB8::200"),
		SrcPort: 50000,
		DstPort: 443,
		Iface:   "L3-2",
		Chain:   pb.Chain_OUTPUT,
		Tcpi:    &pb.TCPInfo{SegsIn: 100, SegsOut: 101},
	}

	TCPSamples1 := []*pb.TCPSample{sample1}
	netNSSample1 := &pb.NetNSSample{Tcp: TCPSamples1}
	oldNsMap["Container-1"] = netNSSample1

	TCPSamples2 := []*pb.TCPSample{sample2, sample3}
	netNSSample2 := &pb.NetNSSample{Tcp: TCPSamples2}
	oldNsMap["Container-2"] = netNSSample2

	oldSamples := &pb.NetSample{
		Ns: oldNsMap,
	}

	TCPSamplesNew1 := []*pb.TCPSample{sample2}
	netNSSampleNew1 := &pb.NetNSSample{Tcp: TCPSamplesNew1}
	newNsMap["Container-1"] = netNSSampleNew1

	TCPSamplesNew2 := []*pb.TCPSample{sample3, sample4}
	netNSSampleNew2 := &pb.NetNSSample{Tcp: TCPSamplesNew2}
	newNsMap["Container-2"] = netNSSampleNew2

	expectedFiltered := make(map[string]*pb.NetNSSample)
	expectedFiltered["Container-1"] = netNSSampleNew1
	expectedFiltered["Container-2"] = &pb.NetNSSample{Tcp: []*pb.TCPSample{sample4}}

	filtered := Filter(newNsMap, oldSamples)

	if !reflect.DeepEqual(expectedFiltered, filtered) {
		t.Errorf("expextedFiltered != filtered, got %#v", filtered)
	}
}
