package yasm

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"

	"go.uber.org/zap"
)

const (
	URL = "http://localhost:11005"
)

type Signal struct {
	Name string  `json:"name"`
	Val  float64 `json:"val"`
}

type TagsMap map[string]string

type Req struct {
	Val  []Signal `json:"values"`
	TTL  uint     `json:"ttl"`
	Tags TagsMap  `json:"tags"`
}

func NewReq(ttl uint, tags TagsMap, s ...Signal) *Req {
	return &Req{
		Val:  s,
		TTL:  ttl,
		Tags: tags,
	}
}

func (r *Req) Push(url string) error {
	l := []*Req{r}
	encReq, err := json.Marshal(l)
	if err != nil {
		return err
	}
	request, err := http.NewRequest("POST", url, bytes.NewBuffer(encReq))
	if err != nil {
		return err
	}
	request.Header.Set("Content-Type", "application/json")
	c := &http.Client{}
	resp, err := c.Do(request)
	if err != nil {
		zap.S().Warnf("Could not sent request: %s", err)
		return err
	}
	defer resp.Body.Close()
	if resp.StatusCode != 200 {
		body, _ := ioutil.ReadAll(resp.Body)
		return fmt.Errorf("bad response code: %d; %s", resp.StatusCode, string(body))
	}
	return nil
}
