package abc

import (
	"context"
	"math/rand"
	"time"

	"a.yandex-team.ru/infra/temporal/clients/abc"
)

type Activities struct {
	abc *abc.Client
}

func NewActivities(abcClientConfig *abc.ClientConfig) *Activities {
	return &Activities{
		abc: abc.NewClient(abcClientConfig),
	}
}

func (a *Activities) GetOnDutyFromSchedule(ctx context.Context, abcScheduleID int) ([]string, error) {
	logins, err := a.abc.GetOnDutyFromSchedule(abcScheduleID)
	return logins, err
}

func (a *Activities) GetOnDutyFromService(ctx context.Context, abcServiceID int) ([]string, error) {
	logins, err := a.abc.GetOnDutyFromService(abcServiceID)
	return logins, err
}

func (a *Activities) GetRandomServiceMembers(ctx context.Context, abcServiceID int, maxSize int) ([]string, error) {
	logins, err := a.abc.GetServiceMembers(abcServiceID)
	if err != nil {
		return nil, err
	}

	rand.Seed(time.Now().UnixNano())
	rand.Shuffle(len(logins), func(i, j int) { logins[i], logins[j] = logins[j], logins[i] })

	if len(logins) < maxSize {
		return logins, nil
	}
	return logins[:maxSize], nil
}
