package calendar

import (
	"context"
	"time"
)

func IsTodayWorkingDay(ctx context.Context) (bool, error) {
	day := 24 * 7 * time.Hour
	holidayDates, err := ListHolidays(time.Now().Add(-day), time.Now().Add(day))
	if err != nil {
		return false, err
	}
	loc, _ := time.LoadLocation("Europe/Moscow")
	currYear, currMonth, currDate := time.Now().In(loc).Date()

	for _, t := range holidayDates {
		year, month, date := t.AsTime().Date()
		if year == currYear && month == currMonth && date == currDate {
			return false, nil
		}
	}
	return true, nil
}

func IsNowWorkingHours(ctx context.Context) (bool, error) {
	loc, _ := time.LoadLocation("Europe/Moscow")
	h := time.Now().In(loc).Hour()
	return h >= 12 && h < 19, nil
}
