package errorbooster

import (
	"context"
	"encoding/json"

	"a.yandex-team.ru/infra/temporal/clients/logbroker"
)

type Data struct {
	Message   string `json:"message"`
	Timestamp int64  `json:"timestamp"`
	Project   string `json:"project"`
}

type Activities struct {
	logbrokerClient *logbroker.Client
}

func NewActivities(logbrokerConfig *logbroker.Config) (*Activities, error) {
	logbrokerClient, err := logbroker.NewClient(logbrokerConfig)
	if err != nil {
		return nil, err
	}

	return &Activities{
		logbrokerClient: logbrokerClient,
	}, nil
}

func (a *Activities) SendLogActivity(ctx context.Context, data *Data) error {
	if err := a.logbrokerClient.Init(ctx); err != nil {
		return err
	}

	binData, err := json.Marshal(data)
	if err != nil {
		return err
	}

	if err := a.logbrokerClient.SendMessageSync(binData); err != nil {
		return err
	}

	return a.logbrokerClient.Close()
}
