package io

import (
	"context"
	"errors"
	"os"
)

type Activities struct{}

func (a *Activities) GetFileContent(ctx context.Context, fileNameEnvVar string) ([]byte, error) {
	// Activity instead of SideEffect for better testability
	fileName, exists := os.LookupEnv(fileNameEnvVar)
	if !exists {
		return nil, errors.New("environment variable for file name is not set")
	}
	return os.ReadFile(fileName)
}
