package services

import (
	"context"
	"testing"

	pb "a.yandex-team.ru/infra/nanny/go/proto/nanny_repo"
	"a.yandex-team.ru/infra/temporal/clients/nanny/mocks"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/suite"
)

type ServicesTestSuite struct {
	suite.Suite
	mockNannyClient *mocks.MockRepoServiceClient
	activities      *Activities
}

func (suite *ServicesTestSuite) SetupTest() {
	ctrl := gomock.NewController(suite.T())
	suite.mockNannyClient = mocks.NewMockRepoServiceClient(ctrl)
	suite.activities = NewActivities("url", "token", suite.mockNannyClient)
}

func (suite *ServicesTestSuite) TestGetServiceReplicationPolicy() {
	suite.mockNannyClient.EXPECT().GetReplicationPolicy(
		gomock.Any(),
		gomock.Any(),
	).Return(
		&pb.GetReplicationPolicyResponse{
			Policy: &pb.ReplicationPolicy{
				Meta: &pb.ReplicationPolicyMeta{Id: "test"},
			},
		}, nil)

	policy, err := suite.activities.GetServiceReplicationPolicy(context.Background(), "test")
	suite.NoError(err)
	suite.Equal("test", policy.Meta.Id)
}

func TestServicesTestSuite(t *testing.T) {
	suite.Run(t, new(ServicesTestSuite))
}
