package startreker

import (
	"context"
	"log"
	"time"

	"a.yandex-team.ru/infra/temporal/clients/abc"
	"a.yandex-team.ru/infra/temporal/clients/startrek"
	"go.temporal.io/sdk/activity"
	"k8s.io/apimachinery/pkg/util/wait"
)

type Activities struct {
	startrek *startrek.Client
	abc      *abc.Client
}

func NewActivities(startrekClientConfig startrek.ClientConfig, abcClientConfig abc.ClientConfig) *Activities {
	// We don't use pointers to avoid config changes during execution
	return &Activities{
		startrek: startrek.NewClient(&startrekClientConfig),
		abc:      abc.NewClient(&abcClientConfig),
	}
}

func (a *Activities) CreateTicket(ticket *startrek.Ticket) (startrek.TicketKey, error) {
	key, err := a.startrek.CreateTicket(ticket)
	return key, err
}

func (a *Activities) UpdateTicket(key startrek.TicketKey, ticket *startrek.Ticket, notify bool) error {
	err := a.startrek.UpdateTicket(key, ticket, notify)
	return err
}

func (a *Activities) CloseTicket(key startrek.TicketKey) error {
	err := a.startrek.CloseTicket(key)
	return err
}

func (a *Activities) CommentTicket(key startrek.TicketKey, comment startrek.Comment) error {
	err := a.startrek.CommentTicket(key, comment)
	return err
}

func (a *Activities) WaitUntilTicketClosed(ctx context.Context, key startrek.TicketKey) (bool, error) {
	log.Println("WaitUntilTicketClosed started")
	const pollingInterval = time.Minute * 5
	log.Printf("pollingInterval: %v\n", pollingInterval)
	for {
		log.Println("Loop started")
		select {
		case <-time.After(pollingInterval + wait.Jitter(time.Minute*2, 1.0)):
			log.Println("Timer ended")
			activity.RecordHeartbeat(ctx)
			log.Println("Heartbeat recorded")
		case <-ctx.Done():
			log.Println("ctx is Done")
			return false, nil
		}
		isOpened, err := a.startrek.IsTicketOpened(key)
		if err != nil {
			return false, err
		}
		if !isOpened {
			return true, nil
		}
	}
}

func (a *Activities) GetOnDuty(ctx context.Context, abcScheduleID int) ([]string, error) {
	logins, err := a.abc.GetOnDutyFromSchedule(abcScheduleID)
	return logins, err
}
