package swat

import (
	"a.yandex-team.ru/infra/temporal/clients/wiki"
	"bytes"
	"context"
	"text/template"
)

type Activities struct {
	wiki *wiki.Client
}

func NewActivities(wikiClientConfig *wiki.ClientConfig) *Activities {
	return &Activities{
		wiki: wiki.NewClient(wikiClientConfig),
	}
}

type RenderedTicket struct {
	Summary     string
	Description string
}

func (a *Activities) RenderTicketTemplate(ctx context.Context, templateWikiPath string, data interface{}) (*RenderedTicket, error) {
	page, err := a.wiki.GetPage(templateWikiPath)
	if err != nil {
		return nil, err
	}
	tmpl, err := template.New("description").Parse(page.Body)
	if err != nil {
		return nil, err
	}
	tmpl, err = tmpl.New("summary").Parse(page.Title)
	if err != nil {
		return nil, err
	}

	var summary bytes.Buffer
	if err := tmpl.ExecuteTemplate(&summary, "summary", data); err != nil {
		return nil, err
	}
	var description bytes.Buffer
	if err := tmpl.ExecuteTemplate(&description, "description", data); err != nil {
		return nil, err
	}
	return &RenderedTicket{
		Summary:     summary.String(),
		Description: description.String(),
	}, nil
}
