package ri

import (
	swatyp "a.yandex-team.ru/infra/temporal/clients/yp"
	"a.yandex-team.ru/yp/go/proto/ypapi"
	"context"
)

type Activities struct {
	client  *swatyp.Client
	cluster string
}

func NewActivities(cluster string, token string) (*Activities, error) {
	c, err := swatyp.NewClient(cluster, token)
	if err != nil {
		return nil, err
	}
	return &Activities{client: c, cluster: cluster}, nil
}

func (a *Activities) SelectReleasesBatchActivity(ctx context.Context, filter string, selectors []string, batchSize int, continuationToken string) (*swatyp.ReleasesBatch, error) {
	return a.client.Releases().SelectBatch(ctx, filter, selectors, batchSize, continuationToken)
}

func (a *Activities) RemoveReleasesByIDsActivity(ctx context.Context, IDs []string) error {
	return a.client.Releases().RemoveByIDs(ctx, IDs)
}

func (a *Activities) SelectDeployTicketsBatchActivity(ctx context.Context, filter string, selectors []string, batchSize int, continuationToken string) (*swatyp.DeployTicketsBatch, error) {
	return a.client.DeployTickets().SelectBatch(ctx, filter, selectors, batchSize, continuationToken)
}

func (a *Activities) GetStagesByIDsActivity(ctx context.Context, IDs []string, selectors []string) ([]*ypapi.TStage, error) {
	return a.client.Stages().GetByIDs(ctx, IDs, selectors)
}

func (a *Activities) RemoveDeployTicketsByIDsActivity(ctx context.Context, IDs []string) error {
	return a.client.DeployTickets().RemoveByIDs(ctx, IDs)
}
