package logbroker

import (
	"context"
	"errors"

	"a.yandex-team.ru/kikimr/public/sdk/go/persqueue"
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb"
)

type Config struct {
	OauthToken string
	Topic      string
	SourceID   string
}

// warning, uses goroutines inside
type Client struct {
	writer persqueue.Writer
}

func NewClient(config *Config) (*Client, error) {
	writer := persqueue.NewWriter(persqueue.WriterOptions{
		Endpoint:       "logbroker.yandex.net",
		Credentials:    ydb.AuthTokenCredentials{AuthToken: config.OauthToken},
		TLSConfig:      nil,
		Database:       "/Root",
		Topic:          config.Topic,
		SourceID:       []byte(config.SourceID),
		Codec:          persqueue.Raw,
		RetryOnFailure: true,
	})
	return &Client{writer: writer}, nil
}

func (c *Client) Init(ctx context.Context) error {
	_, err := c.writer.Init(ctx)
	return err
}

// blocks in case of problems, you may want to call it in separate context
func (c *Client) SendMessageSync(message []byte) error {
	err := c.writer.Write(&persqueue.WriteMessage{Data: message})
	if err != nil {
		return err
	}

	rsp := <-c.writer.C()
	switch m := rsp.(type) {
	case *persqueue.Ack:
		return nil
	case *persqueue.Issue:
		return m.Err
	default:
		return errors.New("unknown write response")
	}
}

func (c *Client) Close() error {
	return c.writer.Close()
}
