package client

import (
	"context"
	"testing"

	pb "a.yandex-team.ru/infra/nanny/go/proto/nanny_repo"
	"a.yandex-team.ru/infra/temporal/clients/nanny/mocks"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/suite"
)

type ClientTestSuite struct {
	suite.Suite
	mockNannyClient *mocks.MockRepoServiceClient
	client          *Client
}

func (suite *ClientTestSuite) SetupTest() {
	ctrl := gomock.NewController(suite.T())
	suite.mockNannyClient = mocks.NewMockRepoServiceClient(ctrl)
	suite.client = NewClient("url", "token", suite.mockNannyClient)
}

func (suite *ClientTestSuite) TestGetService() {
	suite.mockNannyClient.EXPECT().GetService(
		gomock.Any(),
		gomock.Any(),
	).Return(
		&pb.GetServiceResponse{
			Service: &pb.Service{
				Id: "test",
			},
		}, nil)

	s, err := suite.client.GetService(context.Background(), "test", nil)
	suite.NoError(err)
	suite.Equal("test", s.Id)
}

func (suite *ClientTestSuite) TestServiceReplicationPolicy() {
	suite.mockNannyClient.EXPECT().GetReplicationPolicy(
		gomock.Any(),
		gomock.Any(),
	).Return(
		&pb.GetReplicationPolicyResponse{
			Policy: &pb.ReplicationPolicy{
				Meta: &pb.ReplicationPolicyMeta{Id: "test"},
			},
		}, nil)

	policy, err := suite.client.GetServiceReplicationPolicy(context.Background(), "test")
	suite.NoError(err)
	suite.Equal("test", policy.Meta.Id)
}

func TestClientTestSuite(t *testing.T) {
	suite.Run(t, new(ClientTestSuite))
}
