package client

type ServiceDutySchedule struct {
	ABCServiceID int `json:"abc_service_id"`
	ID           int `json:"id"`
}

const EnvTypeTesting = "TESTING"

type ServiceInfoAttrs struct {
	EnvType      string              `json:"env_type,omitempty"`
	DutySchedule ServiceDutySchedule `json:"duty_schedule,omitempty"`
	AbcGroup     int                 `json:"abc_group"`
}

type ChangeInfo struct {
	Author string `json:"author"`
}

type Annotaions struct {
	DeployEngine string `json:"deploy_engine"`
}

type MetaInfo struct {
	Annotaions *Annotaions `json:"annotations"`
}

type ServiceRuntimeAttrsInfo struct {
	ChangeInfo *ChangeInfo `json:"change_info"`
	MetaInfo   *MetaInfo   `json:"meta_info"`
}

type Service struct {
	RuntimeAttrs *ServiceRuntimeAttrsInfo `json:"runtime_attrs"`
	ID           string                   `json:"_id"`
}
