package yp

import (
	"a.yandex-team.ru/yp/go/proto/ypapi"
	"a.yandex-team.ru/yp/go/yp"
	"context"
	"fmt"
	"google.golang.org/protobuf/proto"
)

type ReleasesGetter interface {
	Releases() ReleaseInterface
}

// ReleasesBatch implements batchInterface
type ReleasesBatch struct {
	Items             []*ypapi.TRelease
	ContinuationToken string
}

func (b *ReleasesBatch) MakeEmptyItem() proto.Message {
	return &ypapi.TRelease{}
}

func (b *ReleasesBatch) AddItem(m proto.Message) error {
	r, ok := m.(*ypapi.TRelease)
	if !ok {
		return fmt.Errorf("failed to cast proto message to TRelease")
	}
	b.Items = append(b.Items, r)
	return nil
}

func (b *ReleasesBatch) SetContinuationToken(t string) {
	b.ContinuationToken = t
}

type ReleaseInterface interface {
	SelectBatch(ctx context.Context, filter string, selectors []string, limit int, continuationToken string) (*ReleasesBatch, error)
	RemoveByIDs(ctx context.Context, IDs []string) error
}

// releasesClient implements ReleaseInterface
type releasesClient struct {
	client *yp.Client
}

func newReleases(c *Client) *releasesClient {
	return &releasesClient{
		client: c.base,
	}
}

func (c *releasesClient) SelectBatch(ctx context.Context, filter string, selectors []string, batchSize int, continuationToken string) (*ReleasesBatch, error) {
	b := &ReleasesBatch{
		Items:             make([]*ypapi.TRelease, 0, batchSize),
		ContinuationToken: "",
	}
	if err := selectAndFillBatch(ctx, c.client, filter, ypapi.EObjectType_OT_RELEASE, selectors, batchSize, continuationToken, b); err != nil {
		return nil, err
	}
	return b, nil
}

func (c *releasesClient) RemoveByIDs(ctx context.Context, IDs []string) error {
	return removeByIDs(ctx, c.client, IDs, ypapi.EObjectType_OT_RELEASE)
}
