package yp

import (
	"a.yandex-team.ru/yp/go/proto/ypapi"
	"a.yandex-team.ru/yp/go/yp"
	"context"
	"fmt"
	"google.golang.org/protobuf/proto"
)

type StagesGetter interface {
	Stages() StageInterface
}

// StagesBatch implements batchInterface
type StagesBatch struct {
	Items             []*ypapi.TStage
	ContinuationToken string
}

func (b *StagesBatch) MakeEmptyItem() proto.Message {
	return &ypapi.TStage{}
}

func (b *StagesBatch) AddItem(m proto.Message) error {
	r, ok := m.(*ypapi.TStage)
	if !ok {
		return fmt.Errorf("failed to cast proto message to TStage")
	}
	b.Items = append(b.Items, r)
	return nil
}

func (b *StagesBatch) SetContinuationToken(t string) {
	b.ContinuationToken = t
}

type StageInterface interface {
	SelectBatch(ctx context.Context, filter string, selectors []string, limit int, continuationToken string) (*StagesBatch, error)
	GetByIDs(ctx context.Context, IDs []string, selectors []string) ([]*ypapi.TStage, error)
}

// stagesClient implements StageInterface
type stagesClient struct {
	client *yp.Client
}

func newStages(c *Client) *stagesClient {
	return &stagesClient{
		client: c.base,
	}
}

func (c *stagesClient) SelectBatch(ctx context.Context, filter string, selectors []string, batchSize int, continuationToken string) (*StagesBatch, error) {
	b := &StagesBatch{
		Items:             make([]*ypapi.TStage, 0, batchSize),
		ContinuationToken: "",
	}
	if err := selectAndFillBatch(ctx, c.client, filter, ypapi.EObjectType_OT_STAGE, selectors, batchSize, continuationToken, b); err != nil {
		return nil, err
	}
	return b, nil
}

func (c *stagesClient) GetByIDs(ctx context.Context, IDs []string, selectors []string) ([]*ypapi.TStage, error) {
	b := &StagesBatch{
		Items: make([]*ypapi.TStage, 0, len(IDs)),
	}
	if err := getAndFillBatchByIDs(ctx, c.client, IDs, ypapi.EObjectType_OT_STAGE, selectors, b); err != nil {
		return nil, err
	}
	return b.Items, nil
}
