package yp

import (
	"a.yandex-team.ru/yp/go/proto/ypapi"
	"a.yandex-team.ru/yp/go/yp"
	"context"
	"fmt"
	"google.golang.org/protobuf/proto"
)

type DeployTicketsGetter interface {
	DeployTickets() DeployTicketInterface
}

// DeployTicketsBatch implements batchInterface
type DeployTicketsBatch struct {
	Items             []*ypapi.TDeployTicket
	ContinuationToken string
}

func (b *DeployTicketsBatch) MakeEmptyItem() proto.Message {
	return &ypapi.TDeployTicket{}
}

func (b *DeployTicketsBatch) AddItem(m proto.Message) error {
	r, ok := m.(*ypapi.TDeployTicket)
	if !ok {
		return fmt.Errorf("failed to cast proto message to TDeployTicket")
	}
	b.Items = append(b.Items, r)
	return nil
}

func (b *DeployTicketsBatch) SetContinuationToken(t string) {
	b.ContinuationToken = t
}

type DeployTicketInterface interface {
	SelectBatch(ctx context.Context, filter string, selectors []string, limit int, continuationToken string) (*DeployTicketsBatch, error)
	RemoveByIDs(ctx context.Context, IDs []string) error
}

// ticketsClient implements DeployTicketInterface
type ticketsClient struct {
	client *yp.Client
}

func newDeployTickets(c *Client) *ticketsClient {
	return &ticketsClient{
		client: c.base,
	}
}

func (c *ticketsClient) SelectBatch(ctx context.Context, filter string, selectors []string, batchSize int, continuationToken string) (*DeployTicketsBatch, error) {
	b := &DeployTicketsBatch{
		Items:             make([]*ypapi.TDeployTicket, 0, batchSize),
		ContinuationToken: "",
	}
	if err := selectAndFillBatch(ctx, c.client, filter, ypapi.EObjectType_OT_DEPLOY_TICKET, selectors, batchSize, continuationToken, b); err != nil {
		return nil, err
	}
	return b, nil
}

func (c *ticketsClient) RemoveByIDs(ctx context.Context, IDs []string) error {
	return removeByIDs(ctx, c.client, IDs, ypapi.EObjectType_OT_DEPLOY_TICKET)
}
