package main

import (
	awacsworkflows "a.yandex-team.ru/infra/temporal/workflows/awacs"
	"context"
	"fmt"
	"github.com/spf13/cobra"
	"go.temporal.io/sdk/client"
	"go.uber.org/zap"
	"net/url"
)

func startDeployCertificateRenewalWf() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "start-deploy-cert-renewal-wf",
		Short: "Deploys certificate renewal location by location",
		RunE: func(cmd *cobra.Command, args []string) error {
			namespaceID, err := cmd.Flags().GetString("namespace-id")
			if err != nil {
				return err
			}
			certID, err := cmd.Flags().GetString("id")
			if err != nil {
				return err
			}

			c, err := createTemporalClient()
			if err != nil {
				return err
			}
			defer c.Close()

			workflowID := fmt.Sprintf("deploy-certificate-renewal(%s/%s)", namespaceID, certID)
			options := client.StartWorkflowOptions{
				ID:        workflowID,
				TaskQueue: "awacs",
			}
			we, err := c.ExecuteWorkflow(context.Background(), options, awacsworkflows.DeployCertificateRenewal, namespaceID, certID)
			if err != nil {
				return fmt.Errorf("failed to start DeployCertificateRenewal workflow: %w", err)
			}

			logger.Info("started DeployCertificateRenewal workflow",
				zap.String("ID", we.GetID()), zap.String("RunID", we.GetRunID()))
			return nil
		},
	}
	cmd.Flags().String("namespace-id", "", "certificate namespace id")
	_ = cmd.MarkFlagRequired("namespace-id")
	cmd.Flags().String("id", "", "certificate id")
	_ = cmd.MarkFlagRequired("id")
	return cmd
}

func startScheduleCertificateRenewalDeploymentsWf() *cobra.Command {
	return &cobra.Command{
		Use: "start-schedule-certificate-renewal-deployments-wf",
		RunE: func(cmd *cobra.Command, args []string) error {
			c, err := createTemporalClient()
			if err != nil {
				return err
			}
			defer c.Close()

			workflowID := "deploy-certificate-renewals"
			options := client.StartWorkflowOptions{
				ID:           workflowID,
				TaskQueue:    "awacs",
				CronSchedule: "*/15 * * * *", // every 15 minutes
			}
			_, err = c.ExecuteWorkflow(context.Background(), options, awacsworkflows.ScheduleCertificateRenewalDeployments)
			if err != nil {
				return fmt.Errorf("failed to start ScheduleCertificateRenewalDeployments workflow: %w", err)
			}
			return nil
		},
	}
}

func startContinueRenewedCertificateDeploymentWf() *cobra.Command {
	cmd := &cobra.Command{
		Use: "start-continue-renewed-certificate-deployment-wf",
		RunE: func(cmd *cobra.Command, args []string) error {
			namespaceID, err := cmd.Flags().GetString("namespace-id")
			if err != nil {
				return err
			}
			certID, err := cmd.Flags().GetString("id")
			if err != nil {
				return err
			}

			c, err := createTemporalClient()
			if err != nil {
				return err
			}
			defer c.Close()

			workflowID := fmt.Sprintf("continue-renewed-certificate-deployment(%s/%s)", namespaceID, certID)
			options := client.StartWorkflowOptions{
				ID:        workflowID,
				TaskQueue: "awacs",
			}
			ctx := cmd.Context()
			f, err := c.ExecuteWorkflow(ctx, options, awacsworkflows.ContinueRenewedCertificateDeployment, namespaceID, certID)
			if err != nil {
				return fmt.Errorf("failed to start ContinueRenewedCertificateDeployment workflow: %w", err)
			}
			fmt.Printf("https://swat-temporal.n.yandex-team.ru/namespaces/awacs/workflows/%s/%s/summary\n", url.QueryEscape(f.GetID()), f.GetRunID())
			return nil
		},
	}
	cmd.Flags().String("namespace-id", "", "certificate namespace id")
	_ = cmd.MarkFlagRequired("namespace-id")
	cmd.Flags().String("id", "", "certificate id")
	_ = cmd.MarkFlagRequired("id")
	return cmd
}

func init() {
	rootCmd.AddCommand(startDeployCertificateRenewalWf())
	rootCmd.AddCommand(startContinueRenewedCertificateDeploymentWf())
	rootCmd.AddCommand(startScheduleCertificateRenewalDeploymentsWf())
}
