package main

import (
	temporalclient "a.yandex-team.ru/infra/temporal/swat/client"
	"fmt"
	"go.temporal.io/api/workflowservice/v1"
	"go.temporal.io/sdk/client"
	"os"
)

func createTemporalClient() (client.Client, error) {
	namespace := os.Getenv(TemporalNamespaceEnvVarName)
	if namespace == "" {
		return nil, fmt.Errorf("%s is not set", TemporalNamespaceEnvVarName)
	}

	c, err := temporalclient.NewSdkClient(
		"swat-temporal.yandex.net:7232",
		os.Getenv(TokenEnvVarName),
		os.Getenv(TemporalNamespaceEnvVarName))
	if err != nil {
		return nil, fmt.Errorf("unable to create Temporal client: %w", err)
	}
	return c, nil
}

func createTemporalFrontendClient() (workflowservice.WorkflowServiceClient, error) {
	c, err := temporalclient.CreateGRPCConnection(
		"swat-temporal.yandex.net:7232",
		os.Getenv(TokenEnvVarName),
	)
	if err != nil {
		return nil, err
	}
	return workflowservice.NewWorkflowServiceClient(c), nil
}
