package main

import (
	awacsworkflows "a.yandex-team.ru/infra/temporal/workflows/awacs"
	"context"
	"fmt"
	"github.com/spf13/cobra"
	"go.temporal.io/sdk/client"
	"go.uber.org/zap"
)

func dummy() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "dummy",
		Short: "Does nothing",
		RunE: func(cmd *cobra.Command, args []string) error {
			namespaceID, err := cmd.Flags().GetString("namespace-id")
			if err != nil {
				return err
			}

			c, err := createTemporalClient()
			if err != nil {
				return err
			}
			defer c.Close()

			workflowID := fmt.Sprintf("dummy(%s)", namespaceID)
			options := client.StartWorkflowOptions{
				ID:        workflowID,
				TaskQueue: "awacs",
			}
			we, err := c.ExecuteWorkflow(context.Background(), options, awacsworkflows.DummyWorkflow, namespaceID)
			if err != nil {
				return fmt.Errorf("failed to start DummyWorkflow: %w", err)
			}
			logger.Info("started DummyWorkflow workflow",
				zap.String("ID", we.GetID()), zap.String("RunID", we.GetRunID()))

			return nil
		},
	}
	cmd.Flags().String("namespace-id", "", "namespace id")
	_ = cmd.MarkFlagRequired("namespace-id")
	return cmd
}

func migrateBackendToSDCmd() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "migrate-backend-to-sd",
		Short: "Migrate backend to YP_ENDPOINT_SETS_SD type",
		RunE: func(cmd *cobra.Command, args []string) error {
			namespaceID, err := cmd.Flags().GetString("namespace-id")
			if err != nil {
				return err
			}

			c, err := createTemporalClient()
			if err != nil {
				return err
			}
			defer c.Close()

			workflowID := fmt.Sprintf("migrate-backend-to-sd(%s)", namespaceID)
			options := client.StartWorkflowOptions{
				ID:        workflowID,
				TaskQueue: "awacs",
			}
			we, err := c.ExecuteWorkflow(context.Background(), options, awacsworkflows.MigrateBackendToSDWorkflow, namespaceID)
			if err != nil {
				return fmt.Errorf("failed to start MigrateBackendToSDWorkflow workflow: %w", err)
			}
			logger.Info("started MigrateBackendToSDWorkflow workflow",
				zap.String("ID", we.GetID()), zap.String("RunID", we.GetRunID()))

			return nil
		},
	}
	cmd.Flags().String("namespace-id", "", "awacs namespace id")
	_ = cmd.MarkFlagRequired("namespace-id")
	return cmd
}

func init() {
	rootCmd.AddCommand(dummy())
	rootCmd.AddCommand(migrateBackendToSDCmd())
}
