package main

import (
	"context"
	"flag"
	"fmt"
	"log"
	"os"

	"go.temporal.io/sdk/client"

	temporalClient "a.yandex-team.ru/infra/temporal/swat/client"
	servicePodAlerts "a.yandex-team.ru/infra/temporal/workflows/nanny/servicepodalerts"
)

const TemporalTokenEnvVarName = "TEMPORAL_TOKEN"

func main() {
	serviceID := flag.String("id", "", "service id")
	namespace := flag.String("ns", "", "temporal namespace")
	taskQueue := flag.String("tq", "", "temporal task queue")
	flag.Parse()
	if *serviceID == "" || *namespace == "" || *taskQueue == "" {
		flag.Usage()
		os.Exit(1)
	}

	c, err := temporalClient.NewSdkClient(
		"swat-temporal.yandex.net:7232",
		os.Getenv(TemporalTokenEnvVarName),
		*namespace)
	if err != nil {
		log.Fatalln("unable to create Temporal client", err)
	}
	defer c.Close()

	options := client.StartWorkflowOptions{
		ID:        fmt.Sprintf("pod-alerts-%s", *serviceID),
		TaskQueue: *taskQueue,
	}

	wr, err := c.ExecuteWorkflow(
		context.Background(),
		options,
		servicePodAlerts.ServicePodAlertsWorkflow,
		&servicePodAlerts.WorkflowState{
			ServiceID:           *serviceID,
			Config:              &servicePodAlerts.Config{},
			StartrekerExecution: nil,
			States:              nil,
			Info:                nil,
		},
	)

	if err != nil {
		log.Fatalln("error starting workflow:", err)
	}
	log.Printf(
		"Finished!\nWorkflowID: %s, RunID: %s\n",
		wr.GetID(),
		wr.GetRunID())
}
