package main

import (
	"context"
	"net/http"

	"github.com/go-chi/chi/v5"

	"go.temporal.io/sdk/client"
)

func NewRouter(ctx context.Context, c client.Client) chi.Router {
	router := chi.NewRouter()

	router.Get("/summonInfraDuty/", func(writer http.ResponseWriter, request *http.Request) {
		params := request.URL.Query()
		if len(params["workflowId"]) == 0 {
			writer.WriteHeader(http.StatusBadRequest)
			_, _ = writer.Write([]byte("workflowId must be set"))
			return
		}
		workflowID := params["workflowId"][0]
		err := c.SignalWorkflow(context.TODO(), workflowID, "", "SummonInfraDuty", nil)
		if err != nil {
			writer.WriteHeader(http.StatusInternalServerError)
			_, _ = writer.Write([]byte(err.Error()))
			return
		}
		writer.WriteHeader(http.StatusOK)
	})

	return router
}
