"""
SOLOMON_PROJECT=swat-temporal \
SOLOMON_CLUSTER=frontend \
SOLOMON_SERVICE=frontend \
GRAFANA_DASHBOARD_UID=RolIS4t7z \
TOKEN=AQAD-XXX python augment-frontend.py
"""
import os
import json

import solomon
import grafana
from solomon import *


# Get token by visiting https://oauth.yandex-team.ru/authorize?response_type=token&client_id=aa78b151370f4b5aabf3882ad715d263
# https://oauth.yandex-team.ru/client/aa78b151370f4b5aabf3882ad715d263 is registered to romanovich@
TOKEN = os.getenv('TOKEN')
assert TOKEN

# looks like "RolIS4t7z", can be taken from the dashboard URL:
# https://grafana.yandex-team.ru/d/RolIS4t7z/temporal-frontend
GRAFANA_DASHBOARD_UID = os.getenv('GRAFANA_DASHBOARD_UID')
assert GRAFANA_DASHBOARD_UID

SOLOMON_PROJECT = os.getenv('SOLOMON_PROJECT')
assert SOLOMON_PROJECT

SOLOMON_SERVICE = os.getenv('SOLOMON_SERVICE')
assert SOLOMON_SERVICE

SOLOMON_CLUSTER = os.getenv('SOLOMON_CLUSTER')
assert SOLOMON_CLUSTER

SOLOMON_SPEC = {
    'project': SOLOMON_PROJECT,
    'service': SOLOMON_SERVICE,
    'cluster': SOLOMON_CLUSTER,
}
solomon.SIGNAL_PREFIX = ''
solomon.SPEC = SOLOMON_SPEC

with open('frontend.json') as f:
    dashboard = json.load(f)

promql_to_solomon = {
    'sum (rate(service_requests{type="frontend"}[5m]))':
        sum_(nsignal('service_requests')),

    'sum (rate(service_errors{type="frontend"}[5m]))':
        sum_(nsignal('service_errors')),

    'sum by (operation) (rate(service_requests{type="frontend"}[5m]))':
        alias(group_by_labels(nsignal('service_requests'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    'sum(rate(service_errors_entity_not_found{type="frontend"}[5m]))':
        sum_(nsignal('service_errors_entity_not_found')),

    'sum(rate(service_errors_execution_already_started{type="frontend"}[5m]))':
        sum_(nsignal('service_errors_execution_already_started')),

    'sum(rate(service_errors_resource_exhausted{type="frontend"}[5m]))':
        sum_(nsignal('service_errors_resource_exhausted')),

    'sum by (__name__) (rate({__name__=~"service_errors_.*", type="frontend"}[5m]))':
        alias(group_by_labels(nsignal('service_errors_*'), 'name', "v -> group_lines('sum', v)"), '{{name}}'),

    'histogram_quantile(0.95, sum(rate(service_latency_bucket{type="frontend"}[5m])) by (operation, le))':
        alias(group_by_labels(nsignal('service_latency'), 'operation', "v -> histogram_percentile(95, 'bin', v)"), '{{operation}}'),

    'sum (rate(persistence_requests{type="frontend"}[5m]))':
        sum_(nsignal('persistence_requests')),

    'sum (rate(persistence_errors{type="frontend"}[5m]))':
        sum_(nsignal('persistence_errors')),

    'sum by (operation) (rate(persistence_requests{type="frontend"}[5m]))':
        alias(group_by_labels(signal('persistence_requests'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    'histogram_quantile(0.95, sum(rate(persistence_latency_bucket{type="frontend"}[5m])) by (operation, le))':
        alias(group_by_labels(signal('persistence_latency'), 'operation', "v -> histogram_percentile(95, 'bin', v)"), '{{operation}}'),

    'sum(rate(client_requests{type="frontend", service_role="history"}[5m]))':
        sum_(signal('client_requests', service_role='history')),

    'sum(rate(client_errors{type="frontend", service_role="history"}[5m]))':
        sum_(signal('client_errors', service_role='history')),

    'sum by (operation) (rate(client_requests{type="frontend", service_role="history"}[5m]))':
        alias(group_by_labels(signal('client_requests', service_role='history'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    'sum by (operation) (rate(client_errors{type="frontend", service_role="history"}[5m]))':
        alias(group_by_labels(signal('client_errors', service_role='history'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    'histogram_quantile(0.95, sum(rate(client_latency_bucket{type="frontend", service_role="history"}[5m])) by (operation, le))':
        alias(group_by_labels(signal('client_latency', service_role='history'), 'operation', "v -> histogram_percentile(95, 'bin', v)"), '{{operation}}'),

    'sum(rate(client_requests{type="frontend", service_role="matching"}[5m]))':
        sum_(signal('client_requests', service_role='matching')),

    'sum(rate(client_errors{type="frontend", service_role="matching"}[5m]))':
        sum_(signal('client_errors', service_role='matching')),

    'sum by (operation) (rate(client_requests{type="frontend", service_role="matching"}[5m]))':
        alias(group_by_labels(signal('client_requests', service_role='matching'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    'sum by (operation) (rate(client_errors{type="frontend", service_role="matching"}[5m]))':
        alias(group_by_labels(signal('client_errors', service_role='matching'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    'histogram_quantile(0.95, sum(rate(client_latency_bucket{type="frontend", service_role="matching"}[5m])) by (operation, le))':
        alias(group_by_labels(signal('client_latency', service_role='matching'), 'operation', "v -> histogram_percentile(95, 'bin', v)"), '{{operation}}'),
}
grafana.replace_queries(dashboard, promql_to_solomon)

grafana.update_dashboard(GRAFANA_DASHBOARD_UID, dashboard, TOKEN)

with open('frontend-augmented.json', 'w') as f:
    json.dump(dashboard, f, indent=2)
