"""
SOLOMON_PROJECT=swat-temporal \
SOLOMON_CLUSTER=dev_history \
SOLOMON_SERVICE=dev_history \
GRAFANA_DASHBOARD_UID=4fdV1Ep7z \
TOKEN=AQAD-XXX python augment-history.py
"""
import os
import json

import solomon
import grafana
from solomon import *


# Get token by visiting https://oauth.yandex-team.ru/authorize?response_type=token&client_id=aa78b151370f4b5aabf3882ad715d263
# https://oauth.yandex-team.ru/client/aa78b151370f4b5aabf3882ad715d263 is registered to romanovich@
TOKEN = os.getenv('TOKEN')
assert TOKEN

GRAFANA_DASHBOARD_UID = os.getenv('GRAFANA_DASHBOARD_UID')
assert GRAFANA_DASHBOARD_UID

SOLOMON_PROJECT = os.getenv('SOLOMON_PROJECT')
assert SOLOMON_PROJECT

SOLOMON_SERVICE = os.getenv('SOLOMON_SERVICE')
assert SOLOMON_SERVICE

SOLOMON_CLUSTER = os.getenv('SOLOMON_CLUSTER')
assert SOLOMON_CLUSTER

SOLOMON_SPEC = {
    'project': SOLOMON_PROJECT,
    'service': SOLOMON_SERVICE,
    'cluster': SOLOMON_CLUSTER,
}
solomon.SIGNAL_PREFIX = ''
solomon.SPEC = SOLOMON_SPEC

with open('history.json') as f:
    dashboard = json.load(f)

promql_to_solomon = {
    # History Service

    # Requests Per Operation
    'sum by (operation) (rate(service_requests{type="history"}[5m]))':
        alias(group_by_labels(nsignal('service_requests'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    # Errors Break Down
    'sum(rate(service_errors_resource_exhausted{type="history"}[5m]))':
        sum_(nsignal('service_errors_resource_exhausted')),
    'sum by (__name__) (rate({__name__=~"service_errors_.*", type="history"}[5m]))':
        alias(group_by_labels(nsignal('service_errors_*'), 'name', "v -> group_lines('sum', v)"), '{{name}}'),

    # Transfer Tasks Processing
    # Active Transfer Task Requests Vs Errors
    'sum(rate(task_requests{operation=~"TransferActive.*"}[5m]))':
        sum_(nsignal('task_requests', a='sum', spec={'operation': "TransferActive*"})),
    'sum(rate(task_errors{operation=~"TransferActive.*"}[5m]))':
        sum_(nsignal('task_errors', a='sum', spec={'operation': "TransferActive*"})),

    # Active Transfer Task By Operation
    'sum by (operation) (rate(task_requests{operation=~"TransferActive.*"}[5m]))':
        alias(group_by_labels(nsignal('task_requests', spec={'operation': "TransferActive*"}), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    # Active Transfer Task Errors By Operation
    'sum by (operation) (rate(task_errors{operation=~"TransferActive.*"}[5m]))':
        alias(group_by_labels(nsignal('task_errors', spec={'operation': "TransferActive*"}), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    # Active Transfer Errors Breakdown
    'sum (rate(task_errors_discarded{operation=~"TransferActive.*"}[5m]))':
        sum_(nsignal('task_errors_discarded', a='sum', spec={'operation': "TransferActive*"})),

    'sum (rate(task_errors_limit_exceeded_counter{operation=~"TransferActive.*"}[5m]))':
        sum_(nsignal('task_errors_limit_exceeded_counter', a='sum', spec={'operation': "TransferActive*"})),

    # Active Transfer Task Processing Latency
    'histogram_quantile(0.95, sum(rate(task_latency_processing_bucket{operation=~"TransferActive.*", type="history"}[5m])) by (operation, le))':
        alias(
            group_by_labels(nsignal('task_latency_processing', spec={'operation': "TransferActive*"}), 'operation', "v -> histogram_percentile(95, 'bin', v)"),
            '{{operation}}'),

    # Active Transfer Task Total Latency
    'histogram_quantile(0.95, sum(rate(task_latency_bucket{operation=~"TransferActive.*", type="history"}[5m])) by (operation, le))':
        alias(
            group_by_labels(nsignal('task_latency', spec={'operation': "TransferActive*"}), 'operation', "v -> histogram_percentile(95, 'bin', v)"),
            '{{operation}}'),

    # Timer Tasks Processing

    # Active Timer Errors Breakdown
    'sum (rate(task_errors_discarded{operation=~"TimerActive.*"}[5m]))':
        sum_(nsignal('task_errors_discarded', a='sum', spec={'operation': "TimerActive*"})),
    'sum (rate(task_errors_limit_exceeded_counter{operation=~"TimerActive.*"}[5m]))':
        sum_(nsignal('task_errors_limit_exceeded_counter', a='sum', spec={'operation': "TimerActive*"})),

    # Shard Controller
    # Acquire Shards Count
    'sum(rate(acquire_shards_count[5m]))':
        sum_(nsignal('acquire_shards_count')),

    # Acquire Shards Latency
    'histogram_quantile(0.95, sum(rate(acquire_shards_latency_bucket{type="history"}[5m])) by (le))':
        "histogram_percentile(95, 'bin', {})".format(nsignal('acquire_shards_latency')),

    # Shards Closed
    'sum(rate(shard_closed_count[5m]))':
        sum_(nsignal('shard_closed_count')),

    # Shard Item Counts
    'sum(rate(sharditem_created_count[5m]))':
        sum_(nsignal('sharditem_created_count')),
    'sum(rate(sharditem_removed_count[5m]))':
        sum_(nsignal('sharditem_created_count')),

    # Shard Item Latency
    'histogram_quantile(0.95, sum(rate(sharditem_acquisition_latency{type="history"}[5m])) by (le))':
        "histogram_percentile(95, 'bin', {})".format(nsignal('sharditem_acquisition')),

    # Persistence
    # Request Vs Errors
    'sum (rate(persistence_requests{type="history"}[5m]))':
        sum_(nsignal('persistence_requests')),

    'sum (rate(persistence_errors{type="history"}[5m]))':
        sum_(nsignal('persistence_errors')),

    'sum by (operation) (rate(persistence_requests{type="history"}[5m]))':
        alias(group_by_labels(signal('persistence_requests'), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    'histogram_quantile(0.95, sum(rate(persistence_latency_bucket{type="history"}[5m])) by (operation, le))':
        alias(group_by_labels(nsignal('persistence_latency'), 'operation', "v -> histogram_percentile(95, 'bin', v)"), '{{operation}}'),

}
grafana.replace_queries(dashboard, promql_to_solomon)

grafana.update_dashboard(GRAFANA_DASHBOARD_UID, dashboard, TOKEN)

with open('history-augmented.json', 'w') as f:
    json.dump(dashboard, f, indent=2)
