"""
SOLOMON_PROJECT=swat-temporal \
SOLOMON_CLUSTER=awacs_worker \
SOLOMON_SERVICE=awacs_worker \
GRAFANA_DASHBOARD_UID=WpTankt7k \
TOKEN=AQAD-XXX python augment-sdk.py
"""
import os
import json

import solomon
import grafana
from solomon import *


# Get token by visiting https://oauth.yandex-team.ru/authorize?response_type=token&client_id=aa78b151370f4b5aabf3882ad715d263
# https://oauth.yandex-team.ru/client/aa78b151370f4b5aabf3882ad715d263 is registered to romanovich@
TOKEN = os.getenv('TOKEN')
assert TOKEN

# looks like "WpTankt7k", can be taken from the dashboard URL:
# https://grafana.yandex-team.ru/d/WpTankt7k/temporal-awacs-worker
GRAFANA_DASHBOARD_UID = os.getenv('GRAFANA_DASHBOARD_UID')
assert GRAFANA_DASHBOARD_UID

SOLOMON_PROJECT = os.getenv('SOLOMON_PROJECT')
assert SOLOMON_PROJECT

SOLOMON_SERVICE = os.getenv('SOLOMON_SERVICE')
assert SOLOMON_SERVICE

SOLOMON_CLUSTER = os.getenv('SOLOMON_CLUSTER')
assert SOLOMON_CLUSTER

SOLOMON_SPEC = {
    'project': SOLOMON_PROJECT,
    'service': SOLOMON_SERVICE,
    'cluster': SOLOMON_CLUSTER,
}
solomon.SIGNAL_PREFIX = 'temporal_'
solomon.SPEC = SOLOMON_SPEC

with open('sdk.json') as f:
    dashboard = json.load(f)

by_namespace = {'namespace': '$Namespace'}
promql_to_solomon = {
    # RPC Overview ($Namespace)
    # Requests Vs Failures
    'sum(rate(temporal_request{namespace=~"$Namespace"}[5m]))':
        sum_(nsignal('temporal_request', spec=by_namespace)),

    'sum(rate(temporal_request_failure{namespace=~"$Namespace"}[5m]))':
        sum_(nsignal('temporal_request_failure', spec=by_namespace)),

    # RPC Requests Per Operation
    'sum by (operation) ((rate(temporal_request{namespace=~"$Namespace"}[5m])))':
        alias(group_by_labels(nsignal('temporal_request', spec=by_namespace), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    # RPC Failures Per Operation
    'sum by (operation) (rate(temporal_request_failure{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_request_failure', spec=by_namespace), 'operation', "v -> group_lines('sum', v)"), '{{operation}}'),

    # RPC Latencies ($Namespace)
    'histogram_quantile(0.95, sum by (namespace, operation, le) (rate(temporal_request_latency_bucket{namespace=~"$Namespace"}[5m])))':
        alias(group_by_labels(nsignal('temporal_request_latency', spec=by_namespace), 'operation', "v -> histogram_percentile(95, 'bin', v)"), '{{operation}}'),

    # Workflows
    # Workflow Completion
    'sum(rate(temporal_workflow_completed{namespace=~"$Namespace"}[5m]))':
        sum_(nsignal('temporal_workflow_completed', spec=by_namespace, a='sum')),

    'sum(rate(temporal_workflow_failed{namespace=~"$Namespace"}[5m]))':
        sum_(nsignal('temporal_workflow_failed', spec=by_namespace, a='sum')),

    'sum(rate(temporal_workflow_canceled{namespace=~"$Namespace"}[5m]))':
        sum_(nsignal('temporal_workflow_canceled', spec=by_namespace, a='sum')),

    'sum(rate(temporal_workflow_continue_as_new{namespace=~"$Namespace"}[5m]))':
        sum_(nsignal('temporal_workflow_continue_as_new', spec=by_namespace, a='sum')),

    # Workflow End-To-End Latencies
    'histogram_quantile(0.95, sum(rate(temporal_workflow_endtoend_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, workflow_type, le))':
        alias(group_by_labels(nsignal('temporal_workflow_endtoend_latency', spec=by_namespace), 'workflow_type', "v -> histogram_percentile(95, 'bin', v)"),
              '{{workflow_type}}'),

    # Workflow Success By Type
    'sum by (namespace, workflow_type) (rate(temporal_workflow_completed{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_workflow_completed', spec=by_namespace, a='sum'), 'workflow_type', "v -> group_lines('sum', v)"),
              '{{workflow_type}}'),

    # Workflow Failures By Type
    'sum by (namespace, workflow_type) (rate(temporal_workflow_failed{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_workflow_failed', spec=by_namespace, a='sum'), 'workflow_type', "v -> group_lines('sum', v)"),
              '{{workflow_type}}'),

    # Workflow Task Processing
    # Workflow Task Throughput By WorkflowType
    'sum by (namespace, workflow_type) (rate(temporal_workflow_task_queue_poll_succeed{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_workflow_task_queue_poll_succeed', spec=by_namespace, a='sum'), 'workflow_type', "v -> group_lines('sum', v)"),
              '{{workflow_type}}'),

    # Workflow Task Throughput By Namespace
    'sum by (namespace) (rate(temporal_workflow_task_queue_poll_succeed{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_workflow_task_queue_poll_succeed', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"),
              '{{namespace}}'),

    # Empty Polls
    'sum by (namespace) (rate(temporal_workflow_task_queue_poll_empty{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_workflow_task_queue_poll_empty', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"),
              '{{namespace}}'),

    # Workflow Task Backlog By Namespace
    'histogram_quantile(0.95, sum(rate(temporal_workflow_task_schedule_to_start_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, le))':
        alias(group_by_labels(nsignal('temporal_workflow_task_schedule_to_start_latency', spec=by_namespace), 'namespace',
                              "v -> histogram_percentile(95, 'bin', v)"),
              '{{namespace}}'),

    # Workflow Task Backlog By Workflow Type
    'histogram_quantile(0.95, sum(rate(temporal_workflow_task_schedule_to_start_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, workflow_type, le))':
        alias(group_by_labels(nsignal('temporal_workflow_task_schedule_to_start_latency', spec=by_namespace), 'workflow_type',
                              "v -> histogram_percentile(95, 'bin', v)"),
              '{{workflow_type}}'),

    # Workflow Task Failed By Namespace
    'sum by (namespace) (rate(temporal_workflow_task_execution_failed{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_workflow_task_execution_failed', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"),
              '{{namespace}}'),

    # Workflow Task Failed By Workflow Type
    'sum by (namespace, workflow_type) (rate(temporal_workflow_task_execution_failed{namespace=~"$Namespace"}[5m]))':
        alias(
            group_by_labels(nsignal('temporal_workflow_task_execution_failed', spec=by_namespace, a='sum'), unquoted("as_vector('namespace', 'workflow_type')"),
                            "v -> group_lines('sum', v)"), '{{namespace}} - {{workflow_type}}'),

    # Workflow Task Execution Latency By Namespace
    'histogram_quantile(0.95, sum(rate(temporal_workflow_task_execution_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, le))':
        alias(group_by_labels(nsignal('temporal_workflow_task_execution_latency', spec=by_namespace),
                              'namespace', "v -> histogram_percentile(95, 'bin', v)"), '{{namespace}}'),

    # Workflow Task Execution Latency By Workflow Type
    'histogram_quantile(0.95, sum(rate(temporal_workflow_task_execution_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, workflow_type, le))':
        alias(group_by_labels(nsignal('temporal_workflow_task_execution_latency', spec=by_namespace), unquoted("as_vector('namespace', 'workflow_type')"),
                              "v -> histogram_percentile(95, 'bin', v)"), '{{namespace}} - {{workflow_type}}'),

    # Workflow Task Replay Latency By Namespace
    'histogram_quantile(0.95, sum(rate(temporal_workflow_task_replay_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, le))':
        alias(group_by_labels(nsignal('temporal_workflow_task_replay_latency', spec=by_namespace), 'namespace', "v -> histogram_percentile(95, 'bin', v)"),
              '{{namespace}}'),

    # Workflow Task Replay Latency By Workflow Type
    'histogram_quantile(0.95, sum(rate(temporal_workflow_task_replay_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, workflow_type, le))':
        alias(group_by_labels(nsignal('temporal_workflow_task_replay_latency', spec=by_namespace), unquoted("as_vector('namespace', 'workflow_type')"),
                              "v -> histogram_percentile(95, 'bin', v)"), '{{namespace}} - {{workflow_type}}'),

    # Activities
    # Activity Throughput By Namespace
    'sum by (namespace) (rate(temporal_activity_execution_latency_count{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_activity_execution_latency_count', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"),
              '{{namespace}}'),

    # Activity Throughput By Activity Type
    'sum by (namespace, activity_type) (rate(temporal_activity_execution_latency_count{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_activity_execution_latency_count', spec=by_namespace), unquoted("as_vector('namespace', 'activity_type')"),
                              "v -> group_lines('sum', v)"), '{{namespace}} - {{activity_type}}'),

    # Failed Activity by Type
    'sum by (namespace, activity_type) (rate(temporal_activity_execution_failed{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_activity_execution_failed', spec=by_namespace, a='sum'), unquoted("as_vector('namespace', 'activity_type')"),
                              "v -> group_lines('sum', v)"), '{{namespace}} - {{activity_type}}'),

    # Activity Execution Latencies
    'histogram_quantile(0.95, sum(rate(temporal_activity_execution_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, activity_type, le))':
        alias(group_by_labels(nsignal('temporal_activity_execution_latency', spec=by_namespace), unquoted("as_vector('namespace', 'activity_type')"),
                              "v -> histogram_percentile(95, 'bin', v)"), '{{namespace}} - {{activity_type}}'),

    # Activity End-To-End Latencies
    'histogram_quantile(0.95, sum(rate(temporal_activity_endtoend_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, activity_type, le))':
        alias(group_by_labels(nsignal('temporal_activity_endtoend_latency', spec=by_namespace), unquoted("as_vector('namespace', 'activity_type')"),
                              "v -> histogram_percentile(95, 'bin', v)"), '{{namespace}} - {{activity_type}}'),

    # Empty Activity Polls By Namespace
    'sum by (namespace) (rate(temporal_activity_poll_no_task{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_activity_poll_no_task', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"),
              '{{namespace}}'),

    # Activity Task Backlog By Namespace
    'histogram_quantile(0.95, sum(rate(temporal_activity_schedule_to_start_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, le))':
        alias(
            group_by_labels(nsignal('temporal_activity_schedule_to_start_latency', spec=by_namespace), 'namespace', "v -> histogram_percentile(95, 'bin', v)"),
            '{{namespace}}'),

    # Activity Task Backlog By Activity Type
    'histogram_quantile(0.95, sum(rate(temporal_activity_schedule_to_start_latency_bucket{namespace=~"$Namespace"}[5m])) by (namespace, activity_type, le))':
        alias(group_by_labels(nsignal('temporal_activity_schedule_to_start_latency', spec=by_namespace), unquoted("as_vector('namespace', 'activity_type')"),
                              "v -> histogram_percentile(95, 'bin', v)"), '{{namespace}} - {{activity_type}}'),

    # Sticky Cache
    # Sticky Cache Hit
    'sum by (namespace) (rate(temporal_sticky_cache_hit{namespace=~"$Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_sticky_cache_hit', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"), '{{namespace}}'),

    # Sticky Cache Miss
    'sum by (namespace) (rate(temporal_sticky_cache_miss{namespace=~"Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_sticky_cache_miss', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"), '{{namespace}}'),

    # Sticky Cache Forced Eviction
    'sum by (namespace) (rate(temporal_sticky_cache_total_forced_eviction{namespace=~"Namespace"}[5m]))':
        alias(group_by_labels(nsignal('temporal_sticky_cache_total_forced_eviction', spec=by_namespace, a='sum'), 'namespace', "v -> group_lines('sum', v)"),
              '{{namespace}}'),

    # Sticky Cache Size
    'sum by (namespace) (temporal_sticky_cache_size)':
        alias(group_by_labels(nsignal('temporal_sticky_cache_size', a='sum'), 'namespace', "v -> group_lines('sum', v)"), '{{namespace}}'),
}

grafana.replace_queries(dashboard, promql_to_solomon)

labels = solomon.list_solomon_label_values(SOLOMON_PROJECT, SOLOMON_SPEC, TOKEN)

vars = {
    'Namespace': labels['namespace'],
}

dashboard['templating'] = {
    "list": [
        {
            "current": {
                "selected": True,
                "text": values[0],
                "value": values[0],
            },
            "description": None,
            "error": None,
            "hide": 0,
            "label": None,
            "multi": False,
            "name": name,
            "options": [
                {
                    "selected": False,
                    "text": value,
                    "value": value
                } for value in values
            ],
            "skipUrlSync": False,
            "type": "custom"
        } for name, values in sorted(vars.items())
    ]
}

grafana.update_dashboard(GRAFANA_DASHBOARD_UID, dashboard, TOKEN)

with open('sdk-augmented.json', 'w') as f:
    json.dump(dashboard, f, indent=2)
