import requests


SIGNAL_PREFIX = ''
SPEC = None


class unquoted(object):
    def __init__(self, s):
        self.s = s


def group_by_time(x, i='$__interval', a='avg'):
    return "group_by_time(%s, '%s', %s)" % (i, a, x)


def signal(name, service_role=None, spec=None):
    name = SIGNAL_PREFIX + name
    labels = dict(SPEC)
    if spec is not None:
        labels.update(spec)
    if service_role is not None:
        labels['service_role'] = service_role
    labels['name'] = name
    return '{' + labels_to_solomon_selector(labels) + '}'


def nsignal(name, a='avg', i='$__interval', spec=None):
    return group_by_time(signal(name, spec=spec), a=a, i=i)


def sum_(x):
    return "group_lines('sum', %s)" % x


def alias(x, label):
    return "alias(%s, '%s')" % (x, label)


def group_by_labels(x, label, f):
    if isinstance(label, unquoted):
        label = label.s
    else:
        label = "'{}'".format(label)
    return "group_by_labels(%s, %s, %s)" % (x, label, f)


def labels_to_solomon_selector(spec):
    parts = []
    for k, v in sorted(spec.items()):
        parts.append("'{}'='{}'".format(k, v))
    return ', '.join(parts)


def list_solomon_label_values(project, spec, token):
    resp = requests.get('https://solomon.yandex-team.ru/api/v2/projects/{}/sensors/labels'.format(project), params={
        '_validationFilter': 'ALL',
        'limit': 1000,
        'names': 'namespace',
        'selectors': '{' + labels_to_solomon_selector(spec) + '}',
    }, headers={'Authorization': 'OAuth ' + token})
    resp.raise_for_status()
    labels = resp.json()['labels']

    rv = {}
    for item in labels:
        rv[item['name']] = item['values']
    return rv
