// The MIT License
//
// Copyright (c) 2021 Temporal Technologies Inc.  All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package bench

import "go.temporal.io/sdk/client"

// Activities is a structure with bench activity functions.
type Activities struct {
	temporalClient client.Client
}

// NewActivities creates a new structure with bench activity functions.
func NewActivities(temporalClient client.Client) *Activities {
	return &Activities{temporalClient: temporalClient}
}

// benchTaskQueue is the queue used by worker to pull workflow and activity tasks
const benchTaskQueue = "temporal-bench"

// targetTaskQueue is the queue used by worker to schedule target workflows
const targetTaskQueue = "temporal-basic"

// TestError represents an error that should abort / fail the whole bench test
type TestError struct {
	Message string
}

func (b *TestError) Error() string {
	return b.Message
}
